/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.surface.opengl.draw;

import android.graphics.PointF;
import android.opengl.GLES20;
import com.talpa.translate.camera.surface.opengl.core.Egloo;
import com.talpa.translate.camera.surface.opengl.draw.Gl2dDrawable;
import com.talpa.translate.camera.surface.opengl.extensions.BuffersKt;
import com.talpa.translate.camera.surface.opengl.extensions.MatrixKt;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0014J\b\u0010(\u001a\u00020&H\u0002J\b\u0010)\u001a\u00020&H\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R$\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R$\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/talpa/translate/camera/surface/opengl/draw/GlPolygon;", "Lcom/talpa/translate/camera/surface/opengl/draw/Gl2dDrawable;", "sides", "", "(I)V", "value", "Landroid/graphics/PointF;", "center", "getCenter", "()Landroid/graphics/PointF;", "setCenter", "(Landroid/graphics/PointF;)V", "", "centerX", "getCenterX", "()F", "setCenterX", "(F)V", "centerY", "getCenterY", "setCenterY", "radius", "getRadius", "setRadius", "rotation", "getRotation", "setRotation", "vertexArray", "Ljava/nio/FloatBuffer;", "getVertexArray", "()Ljava/nio/FloatBuffer;", "setVertexArray", "(Ljava/nio/FloatBuffer;)V", "viewportScaleX", "viewportScaleY", "viewportTranslationX", "viewportTranslationY", "draw", "", "onViewportSizeChanged", "onViewportSizeOrCenterChanged", "updateArray", "translation_googleRelease"})
public class GlPolygon
extends Gl2dDrawable {
    private float viewportTranslationX;
    private float viewportTranslationY;
    private float viewportScaleX;
    private float viewportScaleY;
    private float radius;
    private float rotation;
    private float centerX;
    private float centerY;
    @NotNull
    private FloatBuffer vertexArray;
    private final int sides;

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float value) {
        this.radius = value;
        this.updateArray();
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final void setRotation(float value) {
        this.rotation = value % (float)360;
        this.updateArray();
    }

    public final float getCenterX() {
        return this.centerX;
    }

    public final void setCenterX(float value) {
        this.centerX = value;
        this.updateArray();
        this.onViewportSizeOrCenterChanged();
    }

    public final float getCenterY() {
        return this.centerY;
    }

    public final void setCenterY(float value) {
        this.centerY = value;
        this.updateArray();
        this.onViewportSizeOrCenterChanged();
    }

    @NotNull
    public final PointF getCenter() {
        return new PointF(this.centerX, this.centerY);
    }

    public final void setCenter(@NotNull PointF value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setCenterX(value.x);
        this.setCenterY(value.y);
    }

    @Override
    @NotNull
    public FloatBuffer getVertexArray() {
        return this.vertexArray;
    }

    @Override
    public void setVertexArray(@NotNull FloatBuffer floatBuffer) {
        Intrinsics.checkNotNullParameter((Object)floatBuffer, (String)"<set-?>");
        this.vertexArray = floatBuffer;
    }

    private final void updateArray() {
        FloatBuffer array = this.getVertexArray();
        array.clear();
        array.put(this.centerX);
        array.put(this.centerY);
        float angle = this.rotation * (float)(Math.PI / 180);
        float step = (float)(Math.PI * 2) / (float)this.sides;
        int n = this.sides;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            float f = angle;
            boolean bl3 = false;
            array.put(this.centerX + this.radius * (float)Math.cos(f));
            f = angle;
            bl3 = false;
            array.put(this.centerY + this.radius * (float)Math.sin(f));
            angle += step;
        }
        array.put(array.get(2));
        array.put(array.get(3));
        array.flip();
        this.notifyVertexArrayChange();
    }

    @Override
    protected void onViewportSizeChanged() {
        super.onViewportSizeChanged();
        this.onViewportSizeOrCenterChanged();
    }

    private final void onViewportSizeOrCenterChanged() {
        MatrixKt.scale$default(this.getModelMatrix(), 1.0f / this.viewportScaleX, 1.0f / this.viewportScaleY, 0.0f, 4, null);
        MatrixKt.translate$default(this.getModelMatrix(), -this.viewportTranslationX, -this.viewportTranslationY, 0.0f, 4, null);
        if (this.getViewportWidth() > this.getViewportHeight()) {
            this.viewportScaleX = (float)this.getViewportHeight() / (float)this.getViewportWidth();
            this.viewportScaleY = 1.0f;
            this.viewportTranslationX = this.centerX * (1.0f - this.viewportScaleX);
            this.viewportTranslationY = 0.0f;
        } else if (this.getViewportWidth() < this.getViewportHeight()) {
            this.viewportScaleY = (float)this.getViewportWidth() / (float)this.getViewportHeight();
            this.viewportScaleX = 1.0f;
            this.viewportTranslationY = this.centerY * (1.0f - this.viewportScaleY);
            this.viewportTranslationX = 0.0f;
        } else {
            this.viewportScaleX = 1.0f;
            this.viewportScaleY = 1.0f;
            this.viewportTranslationX = 0.0f;
            this.viewportTranslationY = 0.0f;
        }
        MatrixKt.translate$default(this.getModelMatrix(), this.viewportTranslationX, this.viewportTranslationY, 0.0f, 4, null);
        MatrixKt.scale$default(this.getModelMatrix(), this.viewportScaleX, this.viewportScaleY, 0.0f, 4, null);
    }

    @Override
    public void draw() {
        GLES20.glDrawArrays((int)6, (int)0, (int)this.getVertexCount());
        Egloo.checkGlError("glDrawArrays");
    }

    public GlPolygon(int sides) {
        this.sides = sides;
        if (this.sides < 3) {
            throw (Throwable)new IllegalArgumentException("Polygon should have at least 3 sides.");
        }
        this.viewportScaleX = 1.0f;
        this.viewportScaleY = 1.0f;
        this.radius = 1.0f;
        this.vertexArray = BuffersKt.floatBufferOf((this.sides + 2) * this.getCoordsPerVertex());
        this.updateArray();
    }
}

