/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.engine.lock;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.engine.action.ActionHolder;
import com.talpa.translate.camera.view.engine.lock.BaseLock;

@RequiresApi(value=21)
public class ExposureLock
extends BaseLock {
    private static final String TAG = ExposureLock.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);

    @Override
    protected boolean checkIsSupported(@NonNull ActionHolder holder) {
        boolean isNotLegacy = this.readCharacteristic(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL, -1) != 2;
        Integer aeMode = (Integer)holder.getBuilder(this).get(CaptureRequest.CONTROL_AE_MODE);
        boolean isAEOn = aeMode != null && (aeMode == 1 || aeMode == 3 || aeMode == 2 || aeMode == 4 || aeMode == 5);
        boolean result = isNotLegacy && isAEOn;
        LOG.i("checkIsSupported:", result);
        return result;
    }

    @Override
    protected boolean checkShouldSkip(@NonNull ActionHolder holder) {
        TotalCaptureResult lastResult = holder.getLastResult(this);
        if (lastResult != null) {
            Integer aeState = (Integer)lastResult.get(CaptureResult.CONTROL_AE_STATE);
            boolean result = aeState != null && aeState == 3;
            LOG.i("checkShouldSkip:", result);
            return result;
        }
        LOG.i("checkShouldSkip: false - lastResult is null.");
        return false;
    }

    @Override
    protected void onStarted(@NonNull ActionHolder holder) {
        int cancelTrigger = Build.VERSION.SDK_INT >= 23 ? 2 : 0;
        holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)cancelTrigger);
        holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_LOCK, (Object)true);
        holder.applyBuilder(this);
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        super.onCaptureCompleted(holder, request, result);
        Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
        LOG.i("processCapture:", "aeState:", aeState);
        if (aeState == null) {
            return;
        }
        switch (aeState) {
            case 3: {
                this.setState(Integer.MAX_VALUE);
                break;
            }
        }
    }
}

