/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.engine.metering;

import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.engine.offset.Angles;
import com.talpa.translate.camera.view.engine.offset.Axis;
import com.talpa.translate.camera.view.engine.offset.Reference;
import com.talpa.translate.camera.view.metering.MeteringTransform;
import com.talpa.translate.camera.view.size.AspectRatio;
import com.talpa.translate.camera.view.size.Size;

@RequiresApi(value=21)
public class Camera2MeteringTransform
implements MeteringTransform<MeteringRectangle> {
    protected static final String TAG = Camera2MeteringTransform.class.getSimpleName();
    protected static final CameraLogger LOG = CameraLogger.create(TAG);
    private final Angles angles;
    private final Size previewSize;
    private final Size previewStreamSize;
    private final boolean previewIsCropping;
    private final CameraCharacteristics characteristics;
    private final CaptureRequest.Builder builder;

    public Camera2MeteringTransform(@NonNull Angles angles, @NonNull Size previewSize, @NonNull Size previewStreamSize, boolean previewIsCropping, @NonNull CameraCharacteristics characteristics, @NonNull CaptureRequest.Builder builder) {
        this.angles = angles;
        this.previewSize = previewSize;
        this.previewStreamSize = previewStreamSize;
        this.previewIsCropping = previewIsCropping;
        this.characteristics = characteristics;
        this.builder = builder;
    }

    @Override
    @NonNull
    public MeteringRectangle transformMeteringRegion(@NonNull RectF region, int weight) {
        Rect round = new Rect();
        region.round(round);
        return new MeteringRectangle(round, weight);
    }

    @Override
    @NonNull
    public PointF transformMeteringPoint(@NonNull PointF point) {
        PointF referencePoint = new PointF(point.x, point.y);
        Size referenceSize = this.previewSize;
        referenceSize = this.applyPreviewCropping(referenceSize, referencePoint);
        referenceSize = this.applyPreviewScale(referenceSize, referencePoint);
        referenceSize = this.applyPreviewToSensorRotation(referenceSize, referencePoint);
        referenceSize = this.applyCropRegionCoordinates(referenceSize, referencePoint);
        referenceSize = this.applyActiveArrayCoordinates(referenceSize, referencePoint);
        LOG.i("input:", point, "output (before clipping):", referencePoint);
        if (referencePoint.x < 0.0f) {
            referencePoint.x = 0.0f;
        }
        if (referencePoint.y < 0.0f) {
            referencePoint.y = 0.0f;
        }
        if (referencePoint.x > (float)referenceSize.getWidth()) {
            referencePoint.x = referenceSize.getWidth();
        }
        if (referencePoint.y > (float)referenceSize.getHeight()) {
            referencePoint.y = referenceSize.getHeight();
        }
        LOG.i("input:", point, "output (after clipping):", referencePoint);
        return referencePoint;
    }

    @NonNull
    private Size applyPreviewCropping(@NonNull Size referenceSize, @NonNull PointF referencePoint) {
        Size previewStreamSize = this.previewStreamSize;
        Size previewSurfaceSize = referenceSize;
        int referenceWidth = previewSurfaceSize.getWidth();
        int referenceHeight = previewSurfaceSize.getHeight();
        AspectRatio previewStreamAspectRatio = AspectRatio.of(previewStreamSize);
        AspectRatio previewSurfaceAspectRatio = AspectRatio.of(previewSurfaceSize);
        if (this.previewIsCropping) {
            if (previewStreamAspectRatio.toFloat() > previewSurfaceAspectRatio.toFloat()) {
                float scale = previewStreamAspectRatio.toFloat() / previewSurfaceAspectRatio.toFloat();
                referencePoint.x += (float)previewSurfaceSize.getWidth() * (scale - 1.0f) / 2.0f;
                referenceWidth = Math.round((float)previewSurfaceSize.getWidth() * scale);
            } else {
                float scale = previewSurfaceAspectRatio.toFloat() / previewStreamAspectRatio.toFloat();
                referencePoint.y += (float)previewSurfaceSize.getHeight() * (scale - 1.0f) / 2.0f;
                referenceHeight = Math.round((float)previewSurfaceSize.getHeight() * scale);
            }
        }
        return new Size(referenceWidth, referenceHeight);
    }

    @NonNull
    private Size applyPreviewScale(@NonNull Size referenceSize, @NonNull PointF referencePoint) {
        Size previewStreamSize = this.previewStreamSize;
        referencePoint.x *= (float)previewStreamSize.getWidth() / (float)referenceSize.getWidth();
        referencePoint.y *= (float)previewStreamSize.getHeight() / (float)referenceSize.getHeight();
        return previewStreamSize;
    }

    @NonNull
    private Size applyPreviewToSensorRotation(@NonNull Size referenceSize, @NonNull PointF referencePoint) {
        int angle = this.angles.offset(Reference.SENSOR, Reference.VIEW, Axis.ABSOLUTE);
        boolean flip = angle % 180 != 0;
        float tempX = referencePoint.x;
        float tempY = referencePoint.y;
        if (angle == 0) {
            referencePoint.x = tempX;
            referencePoint.y = tempY;
        } else if (angle == 90) {
            referencePoint.x = tempY;
            referencePoint.y = (float)referenceSize.getWidth() - tempX;
        } else if (angle == 180) {
            referencePoint.x = (float)referenceSize.getWidth() - tempX;
            referencePoint.y = (float)referenceSize.getHeight() - tempY;
        } else if (angle == 270) {
            referencePoint.x = (float)referenceSize.getHeight() - tempY;
            referencePoint.y = tempX;
        } else {
            throw new IllegalStateException("Unexpected angle " + angle);
        }
        return flip ? referenceSize.flip() : referenceSize;
    }

    @NonNull
    private Size applyCropRegionCoordinates(@NonNull Size referenceSize, @NonNull PointF referencePoint) {
        Rect cropRect = (Rect)this.builder.get(CaptureRequest.SCALER_CROP_REGION);
        int cropRectWidth = cropRect == null ? referenceSize.getWidth() : cropRect.width();
        int cropRectHeight = cropRect == null ? referenceSize.getHeight() : cropRect.height();
        referencePoint.x += (float)(cropRectWidth - referenceSize.getWidth()) / 2.0f;
        referencePoint.y += (float)(cropRectHeight - referenceSize.getHeight()) / 2.0f;
        return new Size(cropRectWidth, cropRectHeight);
    }

    @NonNull
    private Size applyActiveArrayCoordinates(@NonNull Size referenceSize, @NonNull PointF referencePoint) {
        Rect cropRect = (Rect)this.builder.get(CaptureRequest.SCALER_CROP_REGION);
        referencePoint.x = referencePoint.x + (cropRect == null ? 0.0f : (float)cropRect.left);
        referencePoint.y = referencePoint.y + (cropRect == null ? 0.0f : (float)cropRect.top);
        Rect activeRect = (Rect)this.characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        if (activeRect == null) {
            activeRect = new Rect(0, 0, referenceSize.getWidth(), referenceSize.getHeight());
        }
        return new Size(activeRect.width(), activeRect.height());
    }
}

