package com.talpa.translate.activity

import android.Manifest
import android.app.Activity
import android.content.*
import android.content.pm.PackageManager.PERMISSION_GRANTED
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.provider.MediaStore
import android.text.TextUtils
import androidx.annotation.RestrictTo
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import androidx.core.content.FileProvider
import com.photo.translation.R
import com.talpa.PhotoTranslateController
import com.talpa.translate.base.utils.*
import com.talpa.translate.camera.CameraFragment
import com.talpa.translate.dialog.DiskAlertDialog
import java.io.File

val PERMISSIONS_REQUIRED = arrayOf(
    Manifest.permission.CAMERA,
    Manifest.permission.WRITE_EXTERNAL_STORAGE,
    Manifest.permission.READ_EXTERNAL_STORAGE
)

const val REQUEST_CODE_PERMISSIONS = 100
const val ACTION_FOR_NOTIFICATION_CAMERA = "com.talpa.translate.CAMERA_PENDING"
const val CAMERA_ACTION = "com.talpa.translate.ACTION_FOR_CARMERA"

/**
 * Camera Preview
 *
 * @author CY 2020-02-03
 */
class CameraActivity : AppCompatActivity(), DiskAlertDialog.Callback {

    @RestrictTo(RestrictTo.Scope.LIBRARY)
    companion object {

        fun start(context: Activity, requestCode: Int) {
            val intent = Intent(context, CameraActivity::class.java)
            context.startActivityForResult(intent, requestCode)
        }

        fun start(context: Context, requestCode: Int, screenShotPath: String, id: Long) {
            val intent = Intent(context, CameraActivity::class.java)
            intent.putExtra(PhotoTranslateController.SCREENSHOT_PATH, screenShotPath)
            intent.putExtra(PhotoTranslateController.SCREENSHOT_ID, id)
            intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK
            context.startActivity(intent)
        }

    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        if (!checkPermission(this)) {
            ActivityCompat.requestPermissions(
                this,
                PERMISSIONS_REQUIRED,
                REQUEST_CODE_PERMISSIONS
            )
            return
        } else {
            setContentView(R.layout.activity_camerax)
            dealIntent()
            if (!checkEnv()) {
                showNoticeDialog()
                return
            }
        }
        handleIntent()
    }

    private fun checkEnv(): Boolean {
        return getFreeSpace() >= 30 * 1024
    }

    private fun handleIntent() {
        if (intent.action.equals(ACTION_FOR_NOTIFICATION_CAMERA)) {
            logEvent(NT_notification_click, "opt", "3")
        } else if (intent.action.equals(CAMERA_ACTION)) {
            logEvent(FE_menu_tools, hashMapOf("type" to "pt"))
        }
    }

    override fun onLackUsageConfirm() {
        finish()
    }

    private fun showNoticeDialog() {
        // Create an instance of the dialog fragment and show it
        val dialog = DiskAlertDialog()
            .also {
                it.isCancelable = false
            }
        dialog.show(supportFragmentManager, "DiskAlertDialog")
    }

    private fun dealIntent() {

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            val screenshotId = intent.getLongExtra(PhotoTranslateController.SCREENSHOT_ID, -1L)
            if (screenshotId != -1L) {
                val f = supportFragmentManager.findFragmentById(R.id.container) as? CameraFragment
                if (f != null) {
                    val uri: Uri = ContentUris.withAppendedId(
                        MediaStore.Images.Media.EXTERNAL_CONTENT_URI,
                        screenshotId.toLong()
                    )

                    f.setScreenShotMode(true)
                    f.setImageFromShot(uri)
                }
            }
        } else {
            val screenshot = intent.getStringExtra(PhotoTranslateController.SCREENSHOT_PATH)
            if (!TextUtils.isEmpty(screenshot)) {
                val f = supportFragmentManager.findFragmentById(R.id.container) as? CameraFragment
                if (f != null) {
                    val uri: Uri
                    val file = File(screenshot ?: return)
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        uri =
                            FileProvider.getUriForFile(
                                this,
                                packageName + ".fileProvider",
                                file
                            )
                    } else {
                        uri = Uri.fromFile(file)
                    }

                    f.setScreenShotMode(true)
                    f.setImageFromShot(uri)
                }
            }
        }


    }

    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {

        when (requestCode) {
            REQUEST_CODE_PERMISSIONS -> {
                //&& !supportFragmentManager.isStateSaved
                if (checkPermission(applicationContext)) {
                    //TranslationStateEngine.post(TranslationSessionFactory.buildDefaultSession())
                    setContentView(R.layout.activity_camerax)
                    dealIntent()
                } else {
                    finish()
                }
            }
        }

        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
    }

}
