package com.talpa.translate.activity

import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import com.gyf.immersionbar.BarHide
import com.gyf.immersionbar.ktx.immersionBar
import com.photo.translation.R
import com.talpa.translate.base.utils.checkPermission

/**
 * Create by chenjunsheng on 2021/3/18
 */

const val OCR_RESULT = "ocr_result"

class CameraPickerActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        immersionBar {
            hideBar(BarHide.FLAG_HIDE_BAR)
            fullScreen(true)
        }
        if (!checkPermission(this)) {
            ActivityCompat.requestPermissions(
                this,
                PERMISSIONS_REQUIRED,
                REQUEST_CODE_PERMISSIONS
            )
            return
        } else {
            setContentView(R.layout.camera_picker_activity)
        }
    }

    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {

        when (requestCode) {
            REQUEST_CODE_PERMISSIONS -> {
                //&& !supportFragmentManager.isStateSaved
                if (checkPermission(applicationContext)) {
                    //TranslationStateEngine.post(TranslationSessionFactory.buildDefaultSession())
                    setContentView(R.layout.camera_picker_activity)
                } else {
                    finish()
                }
            }
        }

        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
    }
}