package com.talpa.translate.camera.view.filter

import android.graphics.Color
import androidx.annotation.ColorInt
import androidx.annotation.Keep
import androidx.annotation.Px
import com.talpa.translate.camera.surface.opengl.draw.GlDrawable
import com.talpa.translate.camera.surface.opengl.draw.GlRoundRect

/**
 * Create by chenjunsheng on 2021/3/1
 */
@Keep
class RoundRectFilter : BaseFilter() {

    private var topLeftCorner = 0
    private var topRightCorner = 0
    private var bottomLeftCorner = 0
    private var bottomRightCorner = 0
    @ColorInt
    private var mBackgroundColor = Color.rgb(0, 0, 0)

    override fun getFragmentShader(): String {
        return createDefaultFragmentShader()
    }

    override fun createDrawable(): GlDrawable {
        return GlRoundRect().apply {
            setCornersPx(
                topLeft = topLeftCorner,
                topRight = topRightCorner,
                bottomLeft = bottomLeftCorner,
                bottomRight = bottomRightCorner
            )
            backgroundColor = mBackgroundColor
        }
    }

    fun setBackgroundColor(@ColorInt color: Int) {
        mBackgroundColor = color
    }

    fun setCornersPx(@Px topLeft: Int, @Px topRight: Int, @Px bottomLeft: Int,
                     @Px bottomRight: Int) {
        topLeftCorner = topLeft
        topRightCorner = topRight
        bottomLeftCorner = bottomLeft
        bottomRightCorner = bottomRight
    }
}