/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.activity;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import com.photo.translation.R;
import com.talpa.translate.activity.CameraActivityKt;
import com.talpa.translate.base.utils.StaticesEventKt;
import com.talpa.translate.base.utils.UtilsKt;
import com.talpa.translate.camera.CameraFragment;
import com.talpa.translate.dialog.DiskAlertDialog;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\u0012\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010\f\u001a\u00020\u0007H\u0016J-\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/talpa/translate/activity/CameraActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/talpa/translate/dialog/DiskAlertDialog$Callback;", "()V", "checkEnv", "", "dealIntent", "", "handleIntent", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onLackUsageConfirm", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "showNoticeDialog", "Companion", "translation_googleRelease"})
public final class CameraActivity
extends AppCompatActivity
implements DiskAlertDialog.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!UtilsKt.checkPermission((Context)this)) {
            ActivityCompat.requestPermissions((Activity)((Activity)this), (String[])CameraActivityKt.getPERMISSIONS_REQUIRED(), (int)100);
            return;
        }
        this.setContentView(R.layout.activity_camerax);
        this.dealIntent();
        if (!this.checkEnv()) {
            this.showNoticeDialog();
            return;
        }
        this.handleIntent();
    }

    private final boolean checkEnv() {
        return UtilsKt.getFreeSpace() >= 30720L;
    }

    private final void handleIntent() {
        if (StringsKt.equals$default((String)this.getIntent().getAction(), (String)"com.talpa.translate.CAMERA_PENDING", (boolean)false, (int)2, null)) {
            StaticesEventKt.logEvent("NT_notification_click", "opt", "3");
        } else if (StringsKt.equals$default((String)this.getIntent().getAction(), (String)"com.talpa.translate.ACTION_FOR_CARMERA", (boolean)false, (int)2, null)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"pt")};
            StaticesEventKt.logEvent("FE_menu_tools", MapsKt.hashMapOf((Pair[])pairArray));
        }
    }

    @Override
    public void onLackUsageConfirm() {
        this.finish();
    }

    private final void showNoticeDialog() {
        DiskAlertDialog diskAlertDialog = new DiskAlertDialog();
        boolean bl = false;
        boolean bl2 = false;
        DiskAlertDialog it = diskAlertDialog;
        boolean bl3 = false;
        it.setCancelable(false);
        DiskAlertDialog dialog = diskAlertDialog;
        dialog.show(this.getSupportFragmentManager(), "DiskAlertDialog");
    }

    private final void dealIntent() {
        if (Build.VERSION.SDK_INT >= 29) {
            long screenshotId = this.getIntent().getLongExtra("screenshot_id", -1L);
            if (screenshotId != -1L) {
                CameraFragment f2;
                Fragment fragment = this.getSupportFragmentManager().findFragmentById(R.id.container);
                CameraFragment cameraFragment = f2 = fragment instanceof CameraFragment ? (CameraFragment)fragment : null;
                if (f2 != null) {
                    Uri uri = ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)screenshotId);
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"withAppendedId(\n                        MediaStore.Images.Media.EXTERNAL_CONTENT_URI,\n                        screenshotId.toLong()\n                    )");
                    Uri uri2 = uri;
                    f2.setScreenShotMode(true);
                    f2.setImageFromShot(uri2);
                }
            }
        } else {
            String screenshot = this.getIntent().getStringExtra("screenshot_path");
            if (!TextUtils.isEmpty((CharSequence)screenshot)) {
                CameraFragment f;
                Fragment f2 = this.getSupportFragmentManager().findFragmentById(R.id.container);
                CameraFragment cameraFragment = f = f2 instanceof CameraFragment ? (CameraFragment)f2 : null;
                if (f != null) {
                    String uri = null;
                    String string = screenshot;
                    if (string == null) {
                        return;
                    }
                    File file = new File(string);
                    if (Build.VERSION.SDK_INT >= 24) {
                        string = FileProvider.getUriForFile((Context)((Context)this), (String)Intrinsics.stringPlus((String)this.getPackageName(), (Object)".fileProvider"), (File)file);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUriForFile(\n                                this,\n                                packageName + \".fileProvider\",\n                                file\n                            )");
                        uri = string;
                    } else {
                        string = Uri.fromFile((File)file);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fromFile(file)");
                        uri = string;
                    }
                    f.setScreenShotMode(true);
                    f.setImageFromShot((Uri)uri);
                }
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        int n = requestCode;
        if (n == 100) {
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            if (UtilsKt.checkPermission(context)) {
                this.setContentView(R.layout.activity_camerax);
                this.dealIntent();
            } else {
                this.finish();
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/talpa/translate/activity/CameraActivity$Companion;", "", "()V", "start", "", "context", "Landroid/app/Activity;", "requestCode", "", "Landroid/content/Context;", "screenShotPath", "", "id", "", "translation_googleRelease"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final class Companion {
        private Companion() {
        }

        public final void start(@NotNull Activity context, int requestCode) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent((Context)context, CameraActivity.class);
            context.startActivityForResult(intent, requestCode);
        }

        public final void start(@NotNull Context context, int requestCode, @NotNull String screenShotPath, long id2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)screenShotPath, (String)"screenShotPath");
            Intent intent = new Intent(context, CameraActivity.class);
            intent.putExtra("screenshot_path", screenShotPath);
            intent.putExtra("screenshot_id", id2);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

