/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.base.view.drag;

import com.talpa.translate.base.view.drag.DragSelectTouchListener;
import java.util.HashSet;
import java.util.Set;

public class DragSelectionProcessor
implements DragSelectTouchListener.OnAdvancedDragSelectListener {
    private Mode mMode = Mode.Simple;
    private ISelectionHandler mSelectionHandler;
    private ISelectionStartFinishedListener mStartFinishedListener;
    private HashSet<Integer> mOriginalSelection;
    private boolean mFirstWasSelected;
    private boolean mCheckSelectionState = false;

    public DragSelectionProcessor(ISelectionHandler selectionHandler) {
        this.mSelectionHandler = selectionHandler;
        this.mStartFinishedListener = null;
    }

    public DragSelectionProcessor withMode(Mode mode) {
        this.mMode = mode;
        return this;
    }

    public DragSelectionProcessor withStartFinishedListener(ISelectionStartFinishedListener startFinishedListener) {
        this.mStartFinishedListener = startFinishedListener;
        return this;
    }

    public DragSelectionProcessor withCheckSelectionState(boolean check) {
        this.mCheckSelectionState = check;
        return this;
    }

    @Override
    public void onSelectionStarted(int start) {
        this.mOriginalSelection = new HashSet();
        Set<Integer> selected = this.mSelectionHandler.getSelection();
        if (selected != null) {
            this.mOriginalSelection.addAll(selected);
        }
        this.mFirstWasSelected = this.mOriginalSelection.contains(start);
        switch (this.mMode) {
            case Simple: {
                this.mSelectionHandler.updateSelection(start, start, true, true);
                break;
            }
            case ToggleAndUndo: {
                this.mSelectionHandler.updateSelection(start, start, !this.mOriginalSelection.contains(start), true);
                break;
            }
            case FirstItemDependent: {
                this.mSelectionHandler.updateSelection(start, start, !this.mFirstWasSelected, true);
                break;
            }
            case FirstItemDependentToggleAndUndo: {
                this.mSelectionHandler.updateSelection(start, start, !this.mFirstWasSelected, true);
            }
        }
        if (this.mStartFinishedListener != null) {
            this.mStartFinishedListener.onSelectionStarted(start, this.mFirstWasSelected);
        }
    }

    @Override
    public void onSelectionFinished(int end) {
        this.mOriginalSelection = null;
        if (this.mStartFinishedListener != null) {
            this.mStartFinishedListener.onSelectionFinished(end);
        }
    }

    @Override
    public void onSelectChange(int start, int end, boolean isSelected) {
        switch (this.mMode) {
            case Simple: {
                if (this.mCheckSelectionState) {
                    this.checkedUpdateSelection(start, end, isSelected);
                    break;
                }
                this.mSelectionHandler.updateSelection(start, end, isSelected, false);
                break;
            }
            case ToggleAndUndo: {
                for (int i = start; i <= end; ++i) {
                    this.checkedUpdateSelection(i, i, isSelected ? !this.mOriginalSelection.contains(i) : this.mOriginalSelection.contains(i));
                }
                break;
            }
            case FirstItemDependent: {
                this.checkedUpdateSelection(start, end, isSelected ? !this.mFirstWasSelected : this.mFirstWasSelected);
                break;
            }
            case FirstItemDependentToggleAndUndo: {
                for (int i = start; i <= end; ++i) {
                    this.checkedUpdateSelection(i, i, isSelected ? !this.mFirstWasSelected : this.mOriginalSelection.contains(i));
                }
                break;
            }
        }
    }

    private void checkedUpdateSelection(int start, int end, boolean newSelectionState) {
        if (this.mCheckSelectionState) {
            for (int i = start; i <= end; ++i) {
                if (this.mSelectionHandler.isSelected(i) == newSelectionState) continue;
                this.mSelectionHandler.updateSelection(i, i, newSelectionState, false);
            }
        } else {
            this.mSelectionHandler.updateSelection(start, end, newSelectionState, false);
        }
    }

    public static interface ISelectionStartFinishedListener {
        public void onSelectionStarted(int var1, boolean var2);

        public void onSelectionFinished(int var1);
    }

    public static interface ISelectionHandler {
        public Set<Integer> getSelection();

        public boolean isSelected(int var1);

        public void updateSelection(int var1, int var2, boolean var3, boolean var4);
    }

    public static enum Mode {
        Simple,
        ToggleAndUndo,
        FirstItemDependent,
        FirstItemDependentToggleAndUndo;

    }
}

