/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.surface.opengl.program;

import android.graphics.Color;
import android.opengl.GLES20;
import androidx.annotation.ColorInt;
import com.talpa.translate.camera.surface.opengl.core.Egloo;
import com.talpa.translate.camera.surface.opengl.draw.GlDrawable;
import com.talpa.translate.camera.surface.opengl.program.GlProgram;
import com.talpa.translate.camera.surface.opengl.program.GlProgramLocation;
import java.nio.Buffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u000f2\b\b\u0001\u0010\u0003\u001a\u00020\u0014R \u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/talpa/translate/camera/surface/opengl/program/GlFlatProgram;", "Lcom/talpa/translate/camera/surface/opengl/program/GlProgram;", "()V", "color", "", "getColor$annotations", "getColor", "()[F", "setColor", "([F)V", "fragmentColorHandle", "Lcom/talpa/translate/camera/surface/opengl/program/GlProgramLocation;", "vertexMvpMatrixHandle", "vertexPositionHandle", "onPostDraw", "", "drawable", "Lcom/talpa/translate/camera/surface/opengl/draw/GlDrawable;", "onPreDraw", "modelViewProjectionMatrix", "", "Companion", "translation_googleRelease"})
public class GlFlatProgram
extends GlProgram {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlProgramLocation vertexPositionHandle = this.getAttribHandle("aPosition");
    @NotNull
    private final GlProgramLocation vertexMvpMatrixHandle = this.getUniformHandle("uMVPMatrix");
    @NotNull
    private final GlProgramLocation fragmentColorHandle = this.getUniformHandle("uColor");
    @NotNull
    private float[] color;
    private static final String TAG = GlFlatProgram.class.getSimpleName();
    @NotNull
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nattribute vec4 aPosition;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n}\n";
    @NotNull
    private static final String FRAGMENT_SHADER = "precision mediump float;\nuniform vec4 uColor;\nvoid main() {\n    gl_FragColor = uColor;\n}\n";

    public GlFlatProgram() {
        super(VERTEX_SHADER, FRAGMENT_SHADER);
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        this.color = fArray;
    }

    public final void setColor(@ColorInt int color2) {
        float[] fArray = new float[]{(float)Color.red((int)color2) / 255.0f, (float)Color.green((int)color2) / 255.0f, (float)Color.blue((int)color2) / 255.0f, (float)Color.alpha((int)color2) / 255.0f};
        this.color = fArray;
    }

    @NotNull
    public final float[] getColor() {
        return this.color;
    }

    public final void setColor(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.color = fArray;
    }

    public static /* synthetic */ void getColor$annotations() {
    }

    @Override
    public void onPreDraw(@NotNull GlDrawable drawable2, @NotNull float[] modelViewProjectionMatrix) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)modelViewProjectionMatrix, (String)"modelViewProjectionMatrix");
        super.onPreDraw(drawable2, modelViewProjectionMatrix);
        GLES20.glUniformMatrix4fv((int)this.vertexMvpMatrixHandle.getValue(), (int)1, (boolean)false, (float[])modelViewProjectionMatrix, (int)0);
        Egloo.checkGlError("glUniformMatrix4fv");
        GLES20.glUniform4fv((int)this.fragmentColorHandle.getValue(), (int)1, (float[])this.color, (int)0);
        Egloo.checkGlError("glUniform4fv");
        GLES20.glEnableVertexAttribArray((int)this.vertexPositionHandle.getValue());
        Egloo.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.vertexPositionHandle.getValue(), (int)drawable2.getCoordsPerVertex(), (int)5126, (boolean)false, (int)drawable2.getVertexStride(), (Buffer)drawable2.getVertexArray());
        Egloo.checkGlError("glVertexAttribPointer");
    }

    @Override
    public void onPostDraw(@NotNull GlDrawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        super.onPostDraw(drawable2);
        GLES20.glDisableVertexAttribArray((int)this.vertexPositionHandle.getValue());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/talpa/translate/camera/surface/opengl/program/GlFlatProgram$Companion;", "", "()V", "FRAGMENT_SHADER", "", "TAG", "kotlin.jvm.PlatformType", "getTAG$translation_googleRelease$annotations", "getTAG$translation_googleRelease", "()Ljava/lang/String;", "VERTEX_SHADER", "translation_googleRelease"})
    public static final class Companion {
        private Companion() {
        }

        public final String getTAG$translation_googleRelease() {
            return TAG;
        }

        public static /* synthetic */ void getTAG$translation_googleRelease$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

