/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.record;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcelable;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import androidx.annotation.RestrictTo;
import com.talpa.PhotoTranslateController;
import com.talpa.translate.activity.ScreenRecordActivity;
import com.talpa.translate.network.HiTranslator;
import com.talpa.translate.network.TransResponse;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import com.talpa.translate.record.CaptureManager;
import com.talpa.translate.record.CaptureResult;
import com.talpa.translate.record.CaptureTransResult;
import com.talpa.translate.record.ICaptureController;
import com.talpa.translate.record.IRecordListener;
import com.talpa.translate.record.IRecordService;
import com.talpa.translate.service.RecordService;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0083\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0015\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001cH\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\u001a\u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0016J\u0012\u0010.\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0010\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u000bH\u0017J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u0018H\u0016J \u00103\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u000206H\u0017R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/talpa/translate/record/CaptureManager;", "Landroid/content/ServiceConnection;", "Lcom/talpa/translate/record/ICaptureController;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCaptureJob", "Lkotlinx/coroutines/Job;", "mContext", "kotlin.jvm.PlatformType", "mCurrentState", "", "mLastResult", "Lcom/talpa/translate/record/CaptureTransResult;", "mLastX", "", "mLastY", "mRecognizeJob", "mRecordService", "Lcom/talpa/translate/record/IRecordService;", "mRemoteCallback", "com/talpa/translate/record/CaptureManager$mRemoteCallback$1", "Lcom/talpa/translate/record/CaptureManager$mRemoteCallback$1;", "mResultListener", "Lcom/talpa/PhotoTranslateController$TextRecognizeListener;", "velocityTracker", "Landroid/view/VelocityTracker;", "captureFrameSync", "Lcom/talpa/translate/record/CaptureResult;", "delegateRecTouchEvent", "", "e", "Landroid/view/MotionEvent;", "destroyRecognizeService", "fastAnalyzeArea", "result", "isRectangleOverlap", "", "current", "Landroid/graphics/Rect;", "other", "onServiceConnected", "name", "Landroid/content/ComponentName;", "service", "Landroid/os/IBinder;", "onServiceDisconnected", "setCurrentState", "state", "setTextRecognizeListener", "listener", "startRecordService", "resultCode", "data", "Landroid/content/Intent;", "Companion", "translation_googleRelease"})
public final class CaptureManager
implements ServiceConnection,
ICaptureController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PhotoTranslateController.TextRecognizeListener mResultListener;
    @Nullable
    private IRecordService mRecordService;
    private final Context mContext;
    private int mCurrentState;
    private float mLastX;
    private float mLastY;
    @Nullable
    private Job mCaptureJob;
    @Nullable
    private Job mRecognizeJob;
    @Nullable
    private CaptureTransResult mLastResult;
    @Nullable
    private VelocityTracker velocityTracker;
    @NotNull
    private final mRemoteCallback.1 mRemoteCallback;
    public static final int RECT_GAP_X = 0;
    public static final int RECT_GAP_Y = 15;
    public static final int MIN_DISTANCE = 15;
    public static final int STATE_INITIALIZE = 0;
    public static final int STATE_ASKING_PERMISSION = 1;
    public static final int STATE_PERMISSION_GRANTED = 2;
    public static final int STATE_SERVICE_PREPARED = 3;
    public static final int STATE_CAPTURING_PIC = 4;
    public static final int STATE_CAPTURED_PIC = 5;
    public static final int STATE_RECOGNIZE_START = 6;
    public static final int STATE_RECOGNIZING = 7;
    public static final int STATE_TRANSLATING = 8;
    public static final int STATE_RECOGNIZED_FINISH = 9;
    public static final int STATE_TRANSLATE_FINISH = 10;
    public static final int STATE_ACTION_CLEAR = 11;
    private static final int VELOCITY_TIME_MILLIS = 300;
    private static final int MIN_VELOCITY = 80;

    public CaptureManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mContext = context.getApplicationContext();
        this.mRemoteCallback = new IRecordListener.Stub(this){
            final /* synthetic */ CaptureManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRecordServiceReady() {
                PhotoTranslateController.TextRecognizeListener textRecognizeListener = CaptureManager.access$getMResultListener$p(this.this$0);
                if (textRecognizeListener != null) {
                    textRecognizeListener.onRecognizeServiceReady();
                }
            }
        };
    }

    @Override
    public void setTextRecognizeListener(@NotNull PhotoTranslateController.TextRecognizeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mResultListener = listener;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setCurrentState(int state) {
        this.mCurrentState = state;
    }

    @Override
    @NotNull
    public CaptureResult captureFrameSync(@NotNull Context context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.mRecordService == null) {
            ScreenRecordActivity.Companion.start(context);
            return new CaptureResult(0, null, null, 6, null);
        }
        try {
            object = this.mRecordService;
            Intrinsics.checkNotNull((Object)object);
            object = object.captureFrameSync();
        }
        catch (Exception e) {
            e.printStackTrace();
            object = null;
        }
        Object object2 = object;
        if (object2 == null) {
            return new CaptureResult(2, null, null, 6, null);
        }
        Object result = object2;
        this.fastAnalyzeArea((CaptureResult)result);
        return result;
    }

    private final boolean isRectangleOverlap(Rect current, Rect other) {
        return current.left < other.right && other.left < current.right && current.top < other.bottom && other.top < current.bottom;
    }

    private final void fastAnalyzeArea(CaptureResult result) {
        List<Block> list;
        if (result.getBitmap() == null) {
            return;
        }
        OcrResult ocrResult = result.getOcrResult();
        List<Block> list2 = list = ocrResult == null ? null : ocrResult.getBlocks();
        if (list == null) {
            return;
        }
        List<Block> list3 = list;
        if (list3.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = list3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block block = (Block)element$iv;
            boolean bl = false;
            Rect rect = block.getRect();
            rect.inset(0, -15);
            int n = 0;
            int n2 = rect.left;
            boolean bl2 = false;
            rect.left = Math.max(n, n2);
            n = 0;
            n2 = rect.top;
            bl2 = false;
            rect.top = Math.max(n, n2);
            Bitmap bitmap2 = result.getBitmap();
            Intrinsics.checkNotNull((Object)bitmap2);
            int n3 = bitmap2.getWidth();
            n2 = rect.right;
            bl2 = false;
            rect.right = Math.min(n3, n2);
            Bitmap bitmap3 = result.getBitmap();
            Intrinsics.checkNotNull((Object)bitmap3);
            n = bitmap3.getHeight();
            n2 = rect.bottom;
            bl2 = false;
            rect.bottom = Math.min(n, n2);
        }
        int i = 0;
        while (i < list3.size()) {
            int j = i + 1;
            while (j < list3.size()) {
                int n;
                Rect other;
                Rect rect = list3.get(i).getRect();
                if (this.isRectangleOverlap(rect, other = list3.get(j).getRect())) {
                    rect.union(other);
                    list3.get(i).setText(list3.get(i).getText() + ' ' + list3.get(j).getText());
                    list3.remove(j);
                    n = j;
                    j = n + -1;
                }
                n = j;
                j = n + 1;
            }
            int n = i;
            i = n + 1;
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void startRecordService(@NotNull Context context, int resultCode, @NotNull Intent data) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intent serviceIntent = new Intent(context, RecordService.class);
        serviceIntent.putExtra("project_intent", (Parcelable)data);
        serviceIntent.putExtra("project_code", resultCode);
        context.getApplicationContext().bindService(serviceIntent, (ServiceConnection)this, 1);
    }

    @Override
    public void destroyRecognizeService() {
        IRecordService iRecordService = this.mRecordService;
        if (iRecordService != null) {
            iRecordService.destroyService();
        }
        this.mRecordService = null;
    }

    public void onServiceDisconnected(@Nullable ComponentName name) {
        this.mRecordService = null;
    }

    /*
     * WARNING - void declaration
     */
    public void onServiceConnected(@Nullable ComponentName name, @NotNull IBinder service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        IRecordService iRecordService = IRecordService.Stub.asInterface(service);
        boolean bl = false;
        boolean bl2 = false;
        IRecordService iRecordService2 = iRecordService;
        CaptureManager captureManager = this;
        boolean bl3 = false;
        try {
            void it;
            it.registerListener(this.mRemoteCallback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Unit unit = Unit.INSTANCE;
        captureManager.mRecordService = iRecordService;
        this.setCurrentState(3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void delegateRecTouchEvent(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        VelocityTracker velocityTracker = this.velocityTracker;
        Intrinsics.checkNotNull((Object)velocityTracker);
        velocityTracker.addMovement(e);
        int n = e.getAction();
        switch (n) {
            case 0: {
                Unit unit;
                Unit unit2;
                this.mLastX = e.getRawX();
                this.mLastY = e.getRawY();
                if (this.mRecordService == null) break;
                Job job = this.mRecognizeJob;
                if (job == null) {
                    unit2 = null;
                } else {
                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                    unit2 = Unit.INSTANCE;
                }
                job = this.mCaptureJob;
                if (job == null) {
                    unit = null;
                } else {
                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                    unit = Unit.INSTANCE;
                }
                this.setCurrentState(3);
                break;
            }
            case 2: {
                int n2 = this.mCurrentState;
                switch (n2) {
                    case 0: {
                        float f = e.getRawX() - this.mLastX;
                        boolean bl = false;
                        float dx = Math.abs(f);
                        float f2 = e.getRawY() - this.mLastY;
                        boolean bl2 = false;
                        float dy = Math.abs(f2);
                        f2 = dx * dx + dy * dy;
                        bl2 = false;
                        if (!((float)Math.sqrt(f2) > 15.0f)) break;
                        Context context = this.mContext;
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                        this.captureFrameSync(context);
                        this.setCurrentState(1);
                        break;
                    }
                    case 3: {
                        Unit unit;
                        float dy = e.getRawX() - this.mLastX;
                        boolean bl = false;
                        float dx = Math.abs(dy);
                        float f = e.getRawY() - this.mLastY;
                        boolean bl3 = false;
                        dy = Math.abs(f);
                        f = dx * dx + dy * dy;
                        bl3 = false;
                        if (!((float)Math.sqrt(f) > 15.0f)) break;
                        this.setCurrentState(4);
                        Job job = this.mCaptureJob;
                        if (job == null) {
                            unit = null;
                        } else {
                            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                            unit = Unit.INSTANCE;
                        }
                        this.mCaptureJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int label;
                            final /* synthetic */ CaptureManager this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Context context = CaptureManager.access$getMContext$p(this.this$0);
                                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                                        CaptureResult captureResult = this.this$0.captureFrameSync(context);
                                        CaptureTransResult captureTransResult = new CaptureTransResult(captureResult, null, 2, null);
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        CaptureTransResult captureTransResult2 = captureTransResult;
                                        CaptureManager captureManager = this.this$0;
                                        boolean bl3 = false;
                                        boolean bl4 = false;
                                        captureTransResult2.setTransMap((Map<Integer, TransResponse>)new HashMap<K, V>());
                                        Unit unit = Unit.INSTANCE;
                                        CaptureManager.access$setMLastResult$p(captureManager, captureTransResult);
                                        this.label = 1;
                                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ CaptureManager this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.this$0.setCurrentState(5);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        break;
                    }
                    case 5: {
                        List<Block> list;
                        Object object;
                        Unit unit;
                        Unit unit3;
                        VelocityTracker dx = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)dx);
                        dx.computeCurrentVelocity(300);
                        VelocityTracker dy = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)dy);
                        float xVelocity = dy.getXVelocity();
                        Object object2 = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)object2);
                        float yVelocity = object2.getYVelocity();
                        if (!(xVelocity < 80.0f) || !(yVelocity < 80.0f)) break;
                        object2 = this.mLastResult;
                        if (object2 == null) {
                            unit3 = null;
                            break;
                        }
                        CaptureResult captureResult = ((CaptureTransResult)object2).getCaptureResult();
                        if (captureResult == null) {
                            unit3 = null;
                            break;
                        }
                        CaptureResult captureResult2 = captureResult;
                        boolean bl = false;
                        boolean bl4 = false;
                        CaptureResult result = captureResult2;
                        boolean bl5 = false;
                        Ref.IntRef index = new Ref.IntRef();
                        index.element = -1;
                        Object object3 = result.getOcrResult();
                        if (object3 == null) {
                            unit = null;
                        } else {
                            object = ((OcrResult)object3).getBlocks();
                            if (object == null) {
                                unit = null;
                            } else {
                                list = object;
                                boolean bl6 = false;
                                boolean bl7 = false;
                                List<Block> OcrResult2 = list;
                                boolean bl8 = false;
                                Iterable $this$forEachIndexed$iv = OcrResult2;
                                boolean $i$f$forEachIndexed = false;
                                int index$iv = 0;
                                for (Object item$iv : $this$forEachIndexed$iv) {
                                    void block;
                                    int n3 = index$iv++;
                                    boolean bl9 = false;
                                    if (n3 < 0) {
                                        CollectionsKt.throwIndexOverflow();
                                    }
                                    Block block2 = (Block)item$iv;
                                    int i = n3;
                                    boolean bl10 = false;
                                    if (!block.getRect().contains((int)e.getRawX(), (int)e.getRawY())) continue;
                                    index.element = i;
                                    break;
                                }
                                unit = Unit.INSTANCE;
                            }
                        }
                        if (index.element != -1) {
                            object3 = this.mLastResult;
                            Intrinsics.checkNotNull((Object)object3);
                            ((CaptureTransResult)object3).setWorkingIndex(index.element);
                            this.setCurrentState(6);
                            Object object4 = result.getOcrResult();
                            List<Block> list2 = list = object4 == null ? null : ((OcrResult)object4).getBlocks();
                            Object object5 = list == null ? null : (object = (object4 = list.get(index.element)) == null ? null : ((Block)object4).getRect());
                            if (object != null) {
                                Unit unit4;
                                Unit unit5;
                                List<Block> recognizeRect = object;
                                object = this.mResultListener;
                                if (object == null) {
                                    unit5 = null;
                                } else {
                                    object.onAreaConfirmed((Rect)recognizeRect);
                                    unit5 = Unit.INSTANCE;
                                }
                                object = this.mRecognizeJob;
                                if (object == null) {
                                    unit4 = null;
                                } else {
                                    Job.DefaultImpls.cancel$default((Job)object, null, (int)1, null);
                                    unit4 = Unit.INSTANCE;
                                }
                                this.mRecognizeJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, result, index, recognizeRect, null){
                                    int label;
                                    final /* synthetic */ CaptureManager this$0;
                                    final /* synthetic */ CaptureResult $result;
                                    final /* synthetic */ Ref.IntRef $index;
                                    final /* synthetic */ Rect $recognizeRect;
                                    {
                                        this.this$0 = $receiver;
                                        this.$result = $result;
                                        this.$index = $index;
                                        this.$recognizeRect = $recognizeRect;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object var1_1) {
                                        block11: {
                                            var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)var1_1);
                                                    this.this$0.setCurrentState(7);
                                                    var4_3 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                    var3_4 = var4_3 == null ? null : var4_3.getTransTargetLanguage();
                                                    targetLanguage = var3_4 == null ? Locale.ENGLISH.getLanguage() : var3_4;
                                                    var5_6 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                    var4_3 = var5_6 == null ? null : var5_6.getTransSourceLanguage();
                                                    sourceLanguage = var4_3 == null ? Locale.ENGLISH.getLanguage() : var4_3;
                                                    var5_6 = this.$result.getOcrResult();
                                                    ocrResult = var5_6 == null ? null : ((var6_7 = var5_6.getBlocks()) == null ? null : (Block)CollectionsKt.getOrNull((List)var6_7, (int)this.$index.element));
                                                    this.this$0.setCurrentState(9);
                                                    if (ocrResult == null) break;
                                                    this.this$0.setCurrentState(8);
                                                    this.label = 1;
                                                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransResponse>, Object>(this.this$0, (String)sourceLanguage, targetLanguage, ocrResult, null){
                                                        int label;
                                                        final /* synthetic */ CaptureManager this$0;
                                                        final /* synthetic */ String $sourceLanguage;
                                                        final /* synthetic */ String $targetLanguage;
                                                        final /* synthetic */ Block $ocrResult;
                                                        {
                                                            this.this$0 = $receiver;
                                                            this.$sourceLanguage = $sourceLanguage;
                                                            this.$targetLanguage = $targetLanguage;
                                                            this.$ocrResult = $ocrResult;
                                                            super(2, $completion);
                                                        }

                                                        /*
                                                         * Unable to fully structure code
                                                         */
                                                        @Nullable
                                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                                            block7: {
                                                                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                switch (this.label) {
                                                                    case 0: {
                                                                        ResultKt.throwOnFailure((Object)var1_1);
                                                                        var3_3 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                                        if (var3_3 == null) {
                                                                            v0 = null;
                                                                        } else {
                                                                            var4_4 = var3_3;
                                                                            var5_5 = this.$sourceLanguage;
                                                                            var6_6 = this.$targetLanguage;
                                                                            var7_7 = this.$ocrResult;
                                                                            var8_9 = false;
                                                                            var9_10 = false;
                                                                            it = var4_4;
                                                                            $i$a$-let-CaptureManager$delegateRecTouchEvent$2$2$transResult$1$1 = false;
                                                                            Intrinsics.checkNotNullExpressionValue((Object)var5_5, (String)"sourceLanguage");
                                                                            Intrinsics.checkNotNullExpressionValue((Object)var6_6, (String)"targetLanguage");
                                                                            var12_14 = new String[]{var7_7.getText()};
                                                                            v0 = it.postTranslateSingle(var5_5, (String)var6_6, CollectionsKt.arrayListOf((Object[])var12_14));
                                                                        }
                                                                        var2_15 = v0;
                                                                        if (var2_15 != null) break;
                                                                        var3_3 = this.this$0;
                                                                        var4_4 = this.$sourceLanguage;
                                                                        var5_5 = this.$targetLanguage;
                                                                        var6_6 = this.$ocrResult;
                                                                        var7_8 = false;
                                                                        var8_9 = false;
                                                                        $i$a$-run-CaptureManager$delegateRecTouchEvent$2$2$transResult$1$2 = false;
                                                                        var10_12 = CaptureManager.access$getMContext$p((CaptureManager)var3_3);
                                                                        Intrinsics.checkNotNullExpressionValue((Object)var10_12, (String)"mContext");
                                                                        v1 = HiTranslator.Companion.getInstance((Context)var10_12);
                                                                        Intrinsics.checkNotNullExpressionValue((Object)var4_4, (String)"sourceLanguage");
                                                                        Intrinsics.checkNotNullExpressionValue((Object)var5_5, (String)"targetLanguage");
                                                                        var10_12 = new String[]{var6_6.getText()};
                                                                        this.label = 1;
                                                                        v2 = v1.postTranslateSingle((String)var4_4, var5_5, CollectionsKt.arrayListOf((Object[])var10_12), (Continuation<? super TransResponse>)this);
                                                                        if (v2 == var13_2) {
                                                                            return var13_2;
                                                                        }
                                                                        ** GOTO lbl46
                                                                    }
                                                                    case 1: {
                                                                        $i$a$-run-CaptureManager$delegateRecTouchEvent$2$2$transResult$1$2 = false;
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        v2 = $result;
lbl46:
                                                                        // 2 sources

                                                                        v3 = (TransResponse)v2;
                                                                        break block7;
                                                                    }
                                                                }
                                                                v3 = var2_15;
                                                            }
                                                            return v3;
                                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                        }

                                                        @NotNull
                                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                        }

                                                        @Nullable
                                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super TransResponse> p2) {
                                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                        }
                                                    }), (Continuation)((Continuation)this));
                                                    if (v0 == var9_2) {
                                                        return var9_2;
                                                    }
                                                    ** GOTO lbl26
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
lbl26:
                                                    // 2 sources

                                                    transResult = (TransResponse)v0;
                                                    var6_7 = CaptureManager.access$getMLastResult$p(this.this$0);
                                                    Intrinsics.checkNotNull((Object)var6_7);
                                                    var6_7.setWorkingIndex(-1);
                                                    var7_8 = CaptureManager.access$getMLastResult$p(this.this$0);
                                                    Intrinsics.checkNotNull((Object)var7_8);
                                                    var6_7 = var7_8.getTransMap();
                                                    Intrinsics.checkNotNull((Object)var6_7);
                                                    var7_8 = Boxing.boxInt((int)this.$index.element);
                                                    var8_9 = false;
                                                    var6_7.put(var7_8, transResult);
                                                    var6_7 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                    if (var6_7 != null) {
                                                        v1 = this.$index.element;
                                                        var7_8 = CaptureManager.access$getMLastResult$p(this.this$0);
                                                        Intrinsics.checkNotNull((Object)var7_8);
                                                        var6_7.onRecognized(v1, (CaptureTransResult)var7_8);
                                                    }
                                                    if (CaptureManager.access$getMCurrentState$p(this.this$0) == 11) {
                                                        this.this$0.setCurrentState(3);
                                                        CaptureManager.access$setMLastResult$p(this.this$0, null);
                                                    } else {
                                                        this.this$0.setCurrentState(10);
                                                    }
                                                    break block11;
                                                }
                                            }
                                            if (CaptureManager.access$getMCurrentState$p(this.this$0) == 11) {
                                                this.this$0.setCurrentState(3);
                                                CaptureManager.access$setMLastResult$p(this.this$0, null);
                                            } else {
                                                this.this$0.setCurrentState(10);
                                            }
                                            var5_6 = CaptureManager.access$getMResultListener$p(this.this$0);
                                            if (var5_6 != null) {
                                                var5_6.onRecognizedFail(this.$recognizeRect);
                                            }
                                        }
                                        return Unit.INSTANCE;
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                        }
                        unit3 = Unit.INSTANCE;
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        Unit unit;
                        CaptureTransResult captureTransResult = this.mLastResult;
                        if (captureTransResult == null) {
                            unit = null;
                            break;
                        }
                        CaptureTransResult captureTransResult2 = captureTransResult;
                        boolean bl = false;
                        boolean bl11 = false;
                        CaptureTransResult transResult2 = captureTransResult2;
                        boolean bl12 = false;
                        VelocityTracker velocityTracker2 = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)velocityTracker2);
                        velocityTracker2.computeCurrentVelocity(300);
                        VelocityTracker result = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)result);
                        float xVelocity = result.getXVelocity();
                        Object object = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)object);
                        float yVelocity = object.getYVelocity();
                        if (xVelocity < 80.0f && yVelocity < 80.0f) {
                            Object bl8;
                            Object OcrResult2;
                            Unit unit6;
                            object = transResult2.getCaptureResult();
                            boolean bl13 = false;
                            boolean bl14 = false;
                            Object captureResult = object;
                            boolean bl15 = false;
                            Ref.IntRef index = new Ref.IntRef();
                            index.element = -1;
                            OcrResult ocrResult = ((CaptureResult)captureResult).getOcrResult();
                            if (ocrResult == null) {
                                unit6 = null;
                            } else {
                                OcrResult2 = ocrResult.getBlocks();
                                if (OcrResult2 == null) {
                                    unit6 = null;
                                } else {
                                    bl8 = OcrResult2;
                                    boolean bl16 = false;
                                    boolean bl17 = false;
                                    List<Block> blocks = bl8;
                                    boolean bl18 = false;
                                    Iterable $this$forEachIndexed$iv = blocks;
                                    boolean $i$f$forEachIndexed = false;
                                    int index$iv = 0;
                                    for (Object item$iv : $this$forEachIndexed$iv) {
                                        void block;
                                        int n4 = index$iv++;
                                        boolean bl19 = false;
                                        if (n4 < 0) {
                                            CollectionsKt.throwIndexOverflow();
                                        }
                                        Block block3 = (Block)item$iv;
                                        int i = n4;
                                        boolean bl20 = false;
                                        if (!block.getRect().contains((int)e.getRawX(), (int)e.getRawY())) continue;
                                        index.element = i;
                                        break;
                                    }
                                    unit6 = Unit.INSTANCE;
                                }
                            }
                            if (index.element != -1 && transResult2.getWorkingIndex() != index.element) {
                                Object object6 = ((CaptureResult)captureResult).getOcrResult();
                                Object object7 = bl8 = object6 == null ? null : ((OcrResult)object6).getBlocks();
                                Object object8 = bl8 == null ? null : (OcrResult2 = (object6 = bl8.get(index.element)) == null ? null : ((Block)object6).getRect());
                                if (OcrResult2 != null) {
                                    List<Block> recognizeRect = OcrResult2;
                                    OcrResult2 = transResult2.getTransMap();
                                    if ((OcrResult2 == null ? null : (TransResponse)OcrResult2.get(index.element)) != null) {
                                        Unit unit7;
                                        Unit unit8;
                                        transResult2.setWorkingIndex(index.element);
                                        OcrResult2 = this.mResultListener;
                                        if (OcrResult2 == null) {
                                            unit8 = null;
                                        } else {
                                            OcrResult2.onAreaConfirmed((Rect)recognizeRect);
                                            unit8 = Unit.INSTANCE;
                                        }
                                        OcrResult2 = this.mResultListener;
                                        if (OcrResult2 == null) {
                                            unit7 = null;
                                        } else {
                                            OcrResult2.onRecognized(index.element, transResult2);
                                            unit7 = Unit.INSTANCE;
                                        }
                                    } else {
                                        Unit unit9;
                                        Unit unit10;
                                        transResult2.setWorkingIndex(index.element);
                                        OcrResult2 = this.mResultListener;
                                        if (OcrResult2 == null) {
                                            unit10 = null;
                                        } else {
                                            OcrResult2.onAreaConfirmed((Rect)recognizeRect);
                                            unit10 = Unit.INSTANCE;
                                        }
                                        object6 = this.mResultListener;
                                        bl8 = object6 == null ? null : object6.getTransTargetLanguage();
                                        Object targetLanguage = bl8 == null ? Locale.ENGLISH.getLanguage() : bl8;
                                        Object object9 = this.mResultListener;
                                        object6 = object9 == null ? null : object9.getTransSourceLanguage();
                                        Object sourceLanguage = object6 == null ? Locale.ENGLISH.getLanguage() : object6;
                                        object6 = transResult2.getCaptureResult().getOcrResult();
                                        if (object6 == null) {
                                            unit9 = null;
                                        } else {
                                            Unit unit11;
                                            object9 = object6;
                                            boolean bl21 = false;
                                            boolean bl22 = false;
                                            Object ocrR = object9;
                                            boolean bl23 = false;
                                            Job job = this.mRecognizeJob;
                                            if (job == null) {
                                                unit11 = null;
                                            } else {
                                                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                                                unit11 = Unit.INSTANCE;
                                            }
                                            this.mRecognizeJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, transResult2, index, (String)sourceLanguage, (String)targetLanguage, (OcrResult)ocrR, null){
                                                int label;
                                                final /* synthetic */ CaptureManager this$0;
                                                final /* synthetic */ CaptureTransResult $transResult;
                                                final /* synthetic */ Ref.IntRef $index;
                                                final /* synthetic */ String $sourceLanguage;
                                                final /* synthetic */ String $targetLanguage;
                                                final /* synthetic */ OcrResult $ocrR;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$transResult = $transResult;
                                                    this.$index = $index;
                                                    this.$sourceLanguage = $sourceLanguage;
                                                    this.$targetLanguage = $targetLanguage;
                                                    this.$ocrR = $ocrR;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * Unable to fully structure code
                                                 */
                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)var1_1);
                                                            this.this$0.setCurrentState(8);
                                                            this.label = 1;
                                                            v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransResponse>, Object>(this.this$0, this.$sourceLanguage, this.$targetLanguage, this.$ocrR, this.$index, null){
                                                                int label;
                                                                final /* synthetic */ CaptureManager this$0;
                                                                final /* synthetic */ String $sourceLanguage;
                                                                final /* synthetic */ String $targetLanguage;
                                                                final /* synthetic */ OcrResult $ocrR;
                                                                final /* synthetic */ Ref.IntRef $index;
                                                                {
                                                                    this.this$0 = $receiver;
                                                                    this.$sourceLanguage = $sourceLanguage;
                                                                    this.$targetLanguage = $targetLanguage;
                                                                    this.$ocrR = $ocrR;
                                                                    this.$index = $index;
                                                                    super(2, $completion);
                                                                }

                                                                /*
                                                                 * Unable to fully structure code
                                                                 */
                                                                @Nullable
                                                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                                                    block7: {
                                                                        var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                        switch (this.label) {
                                                                            case 0: {
                                                                                ResultKt.throwOnFailure((Object)var1_1);
                                                                                var3_3 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                                                if (var3_3 == null) {
                                                                                    v0 = null;
                                                                                } else {
                                                                                    var4_4 = var3_3;
                                                                                    var5_5 = this.$sourceLanguage;
                                                                                    var6_6 = this.$targetLanguage;
                                                                                    var7_7 = this.$ocrR;
                                                                                    var8_8 = this.$index;
                                                                                    var9_10 = false;
                                                                                    var10_11 = false;
                                                                                    it = var4_4;
                                                                                    $i$a$-let-CaptureManager$delegateRecTouchEvent$3$1$2$1$transR$1$1 = false;
                                                                                    Intrinsics.checkNotNullExpressionValue((Object)var5_5, (String)"sourceLanguage");
                                                                                    Intrinsics.checkNotNullExpressionValue((Object)var6_6, (String)"targetLanguage");
                                                                                    var13_15 = new String[]{var7_7.getBlocks().get(var8_8.element).getText()};
                                                                                    v0 = it.postTranslateSingle(var5_5, (String)var6_6, CollectionsKt.arrayListOf((Object[])var13_15));
                                                                                }
                                                                                var2_16 = v0;
                                                                                if (var2_16 != null) break;
                                                                                var3_3 = this.this$0;
                                                                                var4_4 = this.$sourceLanguage;
                                                                                var5_5 = this.$targetLanguage;
                                                                                var6_6 = this.$ocrR;
                                                                                var7_7 = this.$index;
                                                                                var8_9 = false;
                                                                                var9_10 = false;
                                                                                $i$a$-run-CaptureManager$delegateRecTouchEvent$3$1$2$1$transR$1$2 = false;
                                                                                var11_13 = CaptureManager.access$getMContext$p((CaptureManager)var3_3);
                                                                                Intrinsics.checkNotNullExpressionValue((Object)var11_13, (String)"mContext");
                                                                                v1 = HiTranslator.Companion.getInstance((Context)var11_13);
                                                                                Intrinsics.checkNotNullExpressionValue((Object)var4_4, (String)"sourceLanguage");
                                                                                Intrinsics.checkNotNullExpressionValue((Object)var5_5, (String)"targetLanguage");
                                                                                var11_13 = new String[]{var6_6.getBlocks().get(var7_7.element).getText()};
                                                                                this.label = 1;
                                                                                v2 = v1.postTranslateSingle((String)var4_4, var5_5, CollectionsKt.arrayListOf((Object[])var11_13), (Continuation<? super TransResponse>)this);
                                                                                if (v2 == var14_2) {
                                                                                    return var14_2;
                                                                                }
                                                                                ** GOTO lbl48
                                                                            }
                                                                            case 1: {
                                                                                $i$a$-run-CaptureManager$delegateRecTouchEvent$3$1$2$1$transR$1$2 = false;
                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                v2 = $result;
lbl48:
                                                                                // 2 sources

                                                                                v3 = (TransResponse)v2;
                                                                                break block7;
                                                                            }
                                                                        }
                                                                        v3 = var2_16;
                                                                    }
                                                                    return v3;
                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                }

                                                                @NotNull
                                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                                }

                                                                @Nullable
                                                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super TransResponse> p2) {
                                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                }
                                                            }), (Continuation)((Continuation)this));
                                                            if (v0 == var6_2) {
                                                                return var6_2;
                                                            }
                                                            ** GOTO lbl15
                                                        }
                                                        case 1: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            v0 = $result;
lbl15:
                                                            // 2 sources

                                                            transR = (TransResponse)v0;
                                                            this.this$0.setCurrentState(10);
                                                            var3_4 = this.$transResult.getTransMap();
                                                            Intrinsics.checkNotNull(var3_4);
                                                            var4_5 = Boxing.boxInt((int)this.$index.element);
                                                            var5_6 = false;
                                                            var3_4.put((Integer)var4_5, (TransResponse)transR);
                                                            var3_4 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                            if (var3_4 != null) {
                                                                var3_4.onRecognized(this.$index.element, this.$transResult);
                                                            }
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                @NotNull
                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                @Nullable
                                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)3, null);
                                            unit9 = Unit.INSTANCE;
                                        }
                                    }
                                }
                            }
                        }
                        unit = Unit.INSTANCE;
                    }
                }
                break;
            }
            case 1: {
                Unit unit;
                if (this.mRecordService != null) {
                    int n5 = this.mCurrentState;
                    switch (n5) {
                        case 10: {
                            this.setCurrentState(3);
                            this.mLastResult = null;
                            break;
                        }
                        case 4: 
                        case 7: 
                        case 8: {
                            this.setCurrentState(11);
                        }
                    }
                } else {
                    this.setCurrentState(0);
                }
                VelocityTracker velocityTracker3 = this.velocityTracker;
                if (velocityTracker3 == null) {
                    unit = null;
                } else {
                    velocityTracker3.recycle();
                    unit = Unit.INSTANCE;
                }
                this.velocityTracker = null;
            }
        }
    }

    public static final /* synthetic */ Context access$getMContext$p(CaptureManager $this) {
        return $this.mContext;
    }

    public static final /* synthetic */ void access$setMLastResult$p(CaptureManager $this, CaptureTransResult captureTransResult) {
        $this.mLastResult = captureTransResult;
    }

    public static final /* synthetic */ PhotoTranslateController.TextRecognizeListener access$getMResultListener$p(CaptureManager $this) {
        return $this.mResultListener;
    }

    public static final /* synthetic */ CaptureTransResult access$getMLastResult$p(CaptureManager $this) {
        return $this.mLastResult;
    }

    public static final /* synthetic */ int access$getMCurrentState$p(CaptureManager $this) {
        return $this.mCurrentState;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/talpa/translate/record/CaptureManager$Companion;", "", "()V", "MIN_DISTANCE", "", "MIN_VELOCITY", "RECT_GAP_X", "RECT_GAP_Y", "STATE_ACTION_CLEAR", "STATE_ASKING_PERMISSION", "STATE_CAPTURED_PIC", "STATE_CAPTURING_PIC", "STATE_INITIALIZE", "STATE_PERMISSION_GRANTED", "STATE_RECOGNIZED_FINISH", "STATE_RECOGNIZE_START", "STATE_RECOGNIZING", "STATE_SERVICE_PREPARED", "STATE_TRANSLATE_FINISH", "STATE_TRANSLATING", "VELOCITY_TIME_MILLIS", "translation_googleRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

