/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.render;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.talpa.translate.base.utils.UtilsKt;
import com.talpa.translate.network.Result;
import com.talpa.translate.network.TransResponse;
import com.talpa.translate.ocr.datasource.CompleteResult;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import com.talpa.translate.render.Render;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/talpa/translate/render/TranslatorRender;", "Lcom/talpa/translate/render/Render;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "mTextPaint", "Landroid/text/TextPaint;", "renderOverlay", "", "renderSource", "Landroid/graphics/Bitmap;", "completeResult", "Lcom/talpa/translate/ocr/datasource/CompleteResult;", "translation_googleRelease"})
public final class TranslatorRender
implements Render {
    @NotNull
    private final Context context;
    @NotNull
    private TextPaint mTextPaint;

    public TranslatorRender(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.mTextPaint = new TextPaint(1);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renderOverlay(@Nullable Bitmap renderSource, @NotNull CompleteResult completeResult) {
        Intrinsics.checkNotNullParameter((Object)completeResult, (String)"completeResult");
        Bitmap bitmap2 = renderSource;
        if (bitmap2 == null) {
            return;
        }
        Canvas canvas = new Canvas(renderSource);
        OcrResult ocrResult = completeResult.getOcrResult();
        Intrinsics.checkNotNull((Object)ocrResult);
        Iterable $this$forEachIndexed$iv = ocrResult.getBlocks();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void block;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Block block2 = (Block)item$iv;
            int index = n;
            boolean bl2 = false;
            this.mTextPaint.setColor(-16777216);
            Rect rect = block.getRect();
            Object object = completeResult.getTransResponse();
            Intrinsics.checkNotNull((Object)object);
            Object object2 = ((TransResponse)object).getResult();
            Intrinsics.checkNotNull((Object)object2);
            List<String> list = ((Result)object2).getTexts();
            Intrinsics.checkNotNull(list);
            int textSize = UtilsKt.getAutofitTextSize(list.get(index), this.mTextPaint, rect, 16, this.getContext());
            this.mTextPaint.setTextSize(TypedValue.applyDimension((int)2, (float)textSize, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics()));
            TransResponse transResponse = completeResult.getTransResponse();
            Intrinsics.checkNotNull((Object)transResponse);
            object = transResponse.getResult();
            Intrinsics.checkNotNull((Object)object);
            object2 = ((Result)object).getTexts();
            Intrinsics.checkNotNull((Object)object2);
            StaticLayout staticLayout = new StaticLayout((CharSequence)object2.get(index), this.mTextPaint, rect.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
            canvas.save();
            canvas.translate((float)rect.left, (float)rect.top);
            staticLayout.draw(canvas);
            canvas.restore();
        }
    }
}

