package com.talpa.translate.base.view

import android.content.Context
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatCheckBox
import com.talpa.translate.base.utils.AntiShakeUtils

/**
 * Create by chenjunsheng on 2020/10/29
 */
class AntiShakeCheckBox @JvmOverloads constructor(
    context: Context,
    attributes: AttributeSet? = null,
    defStyleAttr: Int = 0
) : AppCompatCheckBox(context, attributes, defStyleAttr) {

    override fun performClick(): Boolean {
        if (AntiShakeUtils.isInvalidClick(this)) {
            return true
        } else {
            return super.performClick()
        }
    }
}