package com.talpa.translate.base.view

import android.content.res.Resources
import android.util.TypedValue

/**
 * Create by chenjunsheng on 2020/8/31
 */

/**
 * dp转换px
 *
 * @param dp dp值
 * @return 转换后的px值
 */
fun dp2px(dp: Float): Float {
    return TypedValue.applyDimension(
        TypedValue.COMPLEX_UNIT_DIP,
        dp,
        Resources.getSystem().displayMetrics
    )
}

/**
 * sp转换px
 *
 * @param sp sp值
 * @return 转换后的px值
 */
fun sp2px(sp: Float): Float {
    return TypedValue.applyDimension(
        TypedValue.COMPLEX_UNIT_SP,
        sp,
        Resources.getSystem().displayMetrics
    )
}