package com.talpa.translate.factory

import android.content.Context
import com.talpa.translate.ocr.FirebaseRecognizer
import com.talpa.translate.ocr.GoogleRecognizer
import com.talpa.translate.ocr.Recognizer
import com.talpa.translate.render.Render
import com.talpa.translate.render.TranslatorRender

/**
 * Create by chenjunsheng on 2020/6/17
 */
class TranslatorFactory {

    companion object {
        fun getFirebaseRecognizer(context: Context): Recognizer {
            return FirebaseRecognizer(context)
        }

        fun getRender(context: Context): Render {
            return TranslatorRender(context)
        }

        fun getGoogleRecognizer(context: Context) : Recognizer {
            return GoogleRecognizer(context)
        }
    }
}