package com.talpa.translate.render

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.Paint
import android.text.Layout
import android.text.StaticLayout
import android.text.TextPaint
import android.util.TypedValue
import com.talpa.translate.base.utils.MAX_TEXT_SIZE
import com.talpa.translate.base.utils.SPACINGMULT
import com.talpa.translate.base.utils.getAutofitTextSize
import com.talpa.translate.ocr.datasource.CompleteResult


/**
 * Create by chenjunsheng on 2020/7/14
 */
class TranslatorRender(val context: Context) : Render {

    private var mTextPaint: TextPaint = TextPaint(Paint.ANTI_ALIAS_FLAG)

    override fun renderOverlay(renderSource: Bitmap?, completeResult: CompleteResult) {
        renderSource ?: return
        val canvas = Canvas(renderSource)

        completeResult.ocrResult!!.blocks.forEachIndexed { index, block ->
            mTextPaint.color = Color.BLACK
            val rect = block.rect
            /*val bit = createBlockView(
                context,
                rect,
                transResult.getOrNull(index) ?: return@forEachIndexed
            ) ?: return@forEachIndexed*/
            val textSize = getAutofitTextSize(
                completeResult.transResponse!!.result!!.texts!![index],
                mTextPaint,
                rect,
                MAX_TEXT_SIZE,
                context
            )
            mTextPaint.textSize = TypedValue.applyDimension(
                TypedValue.COMPLEX_UNIT_SP, textSize.toFloat(),
                context.resources.displayMetrics
            )
            val staticLayout = StaticLayout(
                completeResult.transResponse!!.result!!.texts!![index],
                mTextPaint, rect.width(),
                Layout.Alignment.ALIGN_NORMAL,
                SPACINGMULT,
                0.0f,
                false
            )

            canvas.save()
            canvas.translate(rect.left.toFloat(), rect.top.toFloat())

            staticLayout.draw(canvas)
            //canvas.drawBitmap(bit, rect.left.toFloat(), rect.top.toFloat(), null)
            canvas.restore()

        }
    }


}