/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.photo.translation.R;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0002#$B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\b\u0010\u0010\u001a\u00020\nH\u0016J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\u0012\u001a\u00020\f2\n\u0010\u0013\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u001c\u0010\u0014\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\fJ\u001e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\nR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/talpa/translate/camera/PickerParagraphAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/talpa/translate/camera/PickerParagraphAdapter$ParagraphViewHolder;", "ocrResult", "Lcom/talpa/translate/ocr/result/OcrResult;", "(Lcom/talpa/translate/ocr/result/OcrResult;)V", "mClickListener", "Lcom/talpa/translate/camera/PickerParagraphAdapter$ItemClickListener;", "mSelected", "Ljava/util/HashSet;", "", "deselectAll", "", "getItem", "Lcom/talpa/translate/ocr/result/Block;", "position", "getItemCount", "getSelection", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "select", "pos", "selected", "", "selectAll", "selectRange", "start", "end", "setClickListener", "itemClickListener", "toggleSelection", "ItemClickListener", "ParagraphViewHolder", "translation_googleRelease"})
public final class PickerParagraphAdapter
extends RecyclerView.Adapter<ParagraphViewHolder> {
    @NotNull
    private final OcrResult ocrResult;
    @NotNull
    private final HashSet<Integer> mSelected;
    @Nullable
    private ItemClickListener mClickListener;

    public PickerParagraphAdapter(@NotNull OcrResult ocrResult) {
        Intrinsics.checkNotNullParameter((Object)ocrResult, (String)"ocrResult");
        this.ocrResult = ocrResult;
        this.mSelected = new HashSet();
    }

    @NotNull
    public ParagraphViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.paragraph_text_item, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"from(parent.context).inflate(R.layout.paragraph_text_item, parent, false)");
        return new ParagraphViewHolder(view);
    }

    public void onBindViewHolder(@NotNull ParagraphViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Block item = this.ocrResult.getBlocks().get(position);
        holder.getParagraphText().setText((CharSequence)item.getText());
        if (this.mSelected.contains(position)) {
            holder.itemView.setBackgroundResource(R.drawable.paragraph_selected);
        } else {
            holder.itemView.setBackgroundResource(R.drawable.paragraph_unselect);
        }
    }

    public int getItemCount() {
        return this.ocrResult.getBlocks().size();
    }

    @NotNull
    public final HashSet<Integer> getSelection() {
        return this.mSelected;
    }

    public final void setClickListener(@NotNull ItemClickListener itemClickListener) {
        Intrinsics.checkNotNullParameter((Object)itemClickListener, (String)"itemClickListener");
        this.mClickListener = itemClickListener;
    }

    public final void toggleSelection(int pos) {
        if (this.mSelected.contains(pos)) {
            this.mSelected.remove(pos);
        } else {
            this.mSelected.add(pos);
        }
        this.notifyItemChanged(pos);
    }

    public final void select(int pos, boolean selected) {
        if (selected) {
            this.mSelected.add(pos);
        } else {
            this.mSelected.remove(pos);
        }
        this.notifyItemChanged(pos);
    }

    public final void deselectAll() {
        this.mSelected.clear();
        this.notifyDataSetChanged();
    }

    public final void selectAll() {
        int n = 0;
        int n2 = this.ocrResult.getBlocks().size();
        if (n < n2) {
            do {
                int i = n++;
                this.mSelected.add(i);
            } while (n < n2);
        }
        this.notifyDataSetChanged();
    }

    public final void selectRange(int start, int end, boolean selected) {
        int n = start;
        if (n <= end) {
            int i;
            do {
                i = n++;
                if (selected) {
                    this.mSelected.add(i);
                    continue;
                }
                this.mSelected.remove(i);
            } while (i != end);
        }
        this.notifyItemRangeChanged(start, end - start + 1);
    }

    @NotNull
    public final Block getItem(int position) {
        return this.ocrResult.getBlocks().get(position);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\n"}, d2={"Lcom/talpa/translate/camera/PickerParagraphAdapter$ItemClickListener;", "", "onItemClick", "", "view", "Landroid/view/View;", "position", "", "onItemLongClick", "", "translation_googleRelease"})
    public static interface ItemClickListener {
        public void onItemClick(@NotNull View var1, int var2);

        public boolean onItemLongClick(@NotNull View var1, int var2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/talpa/translate/camera/PickerParagraphAdapter$ParagraphViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Landroid/view/View$OnClickListener;", "Landroid/view/View$OnLongClickListener;", "itemView", "Landroid/view/View;", "(Lcom/talpa/translate/camera/PickerParagraphAdapter;Landroid/view/View;)V", "paragraphText", "Landroid/widget/TextView;", "kotlin.jvm.PlatformType", "getParagraphText", "()Landroid/widget/TextView;", "onClick", "", "v", "onLongClick", "", "translation_googleRelease"})
    public final class ParagraphViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnLongClickListener {
        private final TextView paragraphText;

        public ParagraphViewHolder(View itemView) {
            Intrinsics.checkNotNullParameter((Object)((Object)PickerParagraphAdapter.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            this.paragraphText = (TextView)itemView.findViewById(R.id.paragraph_text);
            this.paragraphText.setOnClickListener((View.OnClickListener)this);
            this.paragraphText.setOnLongClickListener((View.OnLongClickListener)this);
        }

        public final TextView getParagraphText() {
            return this.paragraphText;
        }

        public void onClick(@NotNull View v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            ItemClickListener itemClickListener = PickerParagraphAdapter.this.mClickListener;
            if (itemClickListener != null) {
                itemClickListener.onItemClick(v, this.getAdapterPosition());
            }
        }

        public boolean onLongClick(@NotNull View v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            ItemClickListener itemClickListener = PickerParagraphAdapter.this.mClickListener;
            return itemClickListener == null ? false : itemClickListener.onItemLongClick(v, this.getAdapterPosition());
        }
    }
}

