/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.controls;

import android.content.Context;
import android.content.res.TypedArray;
import androidx.annotation.NonNull;
import com.photo.translation.R;
import com.talpa.translate.camera.view.controls.Audio;
import com.talpa.translate.camera.view.controls.Engine;
import com.talpa.translate.camera.view.controls.Facing;
import com.talpa.translate.camera.view.controls.Flash;
import com.talpa.translate.camera.view.controls.Grid;
import com.talpa.translate.camera.view.controls.Hdr;
import com.talpa.translate.camera.view.controls.Mode;
import com.talpa.translate.camera.view.controls.PictureFormat;
import com.talpa.translate.camera.view.controls.Preview;
import com.talpa.translate.camera.view.controls.VideoCodec;
import com.talpa.translate.camera.view.controls.WhiteBalance;

public class ControlParser {
    private int preview;
    private int facing;
    private int flash;
    private int grid;
    private int whiteBalance;
    private int mode;
    private int hdr;
    private int audio;
    private int videoCodec;
    private int engine;
    private int pictureFormat;

    public ControlParser(@NonNull Context context, @NonNull TypedArray array) {
        this.preview = array.getInteger(R.styleable.CameraView_cameraPreview, Preview.DEFAULT.value());
        this.facing = array.getInteger(R.styleable.CameraView_cameraFacing, Facing.DEFAULT(context).value());
        this.flash = array.getInteger(R.styleable.CameraView_cameraFlash, Flash.DEFAULT.value());
        this.grid = array.getInteger(R.styleable.CameraView_cameraGrid, Grid.DEFAULT.value());
        this.whiteBalance = array.getInteger(R.styleable.CameraView_cameraWhiteBalance, WhiteBalance.DEFAULT.value());
        this.mode = array.getInteger(R.styleable.CameraView_cameraMode, Mode.DEFAULT.value());
        this.hdr = array.getInteger(R.styleable.CameraView_cameraHdr, Hdr.DEFAULT.value());
        this.audio = array.getInteger(R.styleable.CameraView_cameraAudio, Audio.DEFAULT.value());
        this.videoCodec = array.getInteger(R.styleable.CameraView_cameraVideoCodec, VideoCodec.DEFAULT.value());
        this.engine = array.getInteger(R.styleable.CameraView_cameraEngine, Engine.DEFAULT.value());
        this.pictureFormat = array.getInteger(R.styleable.CameraView_cameraPictureFormat, PictureFormat.DEFAULT.value());
    }

    @NonNull
    public Preview getPreview() {
        return Preview.fromValue(this.preview);
    }

    @NonNull
    public Facing getFacing() {
        return Facing.fromValue(this.facing);
    }

    @NonNull
    public Flash getFlash() {
        return Flash.fromValue(this.flash);
    }

    @NonNull
    public Grid getGrid() {
        return Grid.fromValue(this.grid);
    }

    @NonNull
    public Mode getMode() {
        return Mode.fromValue(this.mode);
    }

    @NonNull
    public WhiteBalance getWhiteBalance() {
        return WhiteBalance.fromValue(this.whiteBalance);
    }

    @NonNull
    public Hdr getHdr() {
        return Hdr.fromValue(this.hdr);
    }

    @NonNull
    public Audio getAudio() {
        return Audio.fromValue(this.audio);
    }

    @NonNull
    public VideoCodec getVideoCodec() {
        return VideoCodec.fromValue(this.videoCodec);
    }

    @NonNull
    public Engine getEngine() {
        return Engine.fromValue(this.engine);
    }

    @NonNull
    public PictureFormat getPictureFormat() {
        return PictureFormat.fromValue(this.pictureFormat);
    }
}

