/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.markers;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.talpa.translate.camera.view.markers.Marker;
import java.util.HashMap;

public class MarkerLayout
extends FrameLayout {
    public static final int TYPE_AUTOFOCUS = 1;
    @SuppressLint(value={"UseSparseArrays"})
    private final HashMap<Integer, View> mViews = new HashMap();
    private int mDisplayWidth;

    public MarkerLayout(@NonNull Context context) {
        super(context);
        Resources resources = this.getResources();
        DisplayMetrics dm = resources.getDisplayMetrics();
        this.mDisplayWidth = dm.widthPixels;
    }

    public void onMarker(int type, @Nullable Marker marker) {
        View oldView = this.mViews.get(type);
        if (oldView != null) {
            this.removeView(oldView);
        }
        if (marker == null) {
            return;
        }
        View newView = marker.onAttach(this.getContext(), (ViewGroup)this);
        if (newView != null) {
            this.mViews.put(type, newView);
            this.addView(newView);
        }
    }

    public void onEvent(int type, @NonNull PointF[] points) {
        View view = this.mViews.get(type);
        if (view == null) {
            return;
        }
        view.clearAnimation();
        if (type == 1) {
            PointF point = points[0];
            float x = (int)(point.x - (float)(view.getWidth() / 2));
            float y = (int)(point.y - (float)(view.getHeight() / 2));
            if (view.getLayoutDirection() == 1) {
                view.setTranslationX(-((float)(this.mDisplayWidth - view.getWidth() / 2) - point.x));
            } else {
                view.setTranslationX(x);
            }
            view.setTranslationY(y);
        }
    }
}

