@file:Suppress("unused")

package com.talpa.translate.camera.surface.opengl.buffer

import android.opengl.GLES20
import com.talpa.translate.camera.surface.opengl.core.Egloo
import com.talpa.translate.camera.surface.opengl.core.GlBindable

open class GlBuffer(val target: Int, id: Int? = null) : GlBindable {

    val id = id ?: run {
        val array = IntArray(1)
        GLES20.glGenBuffers(1, array, 0)
        Egloo.checkGlError("glGenBuffers")
        array[0]
    }

    override fun bind() {
        GLES20.glBindBuffer(target, id)
    }

    override fun unbind() {
        GLES20.glBindBuffer(target, 0)
    }

    fun release() {
        GLES20.glDeleteBuffers(1, intArrayOf(id), 0)
    }
}