package com.talpa.translate.ocr

import android.graphics.Bitmap
import android.graphics.Rect
import com.talpa.translate.ocr.thirdpart.tesseract.TessBaseAPI

/**
 * Create by chenjunsheng on 2020/8/5
 */
class TextRecognitionHelper {

    private val tessBaseApi: TessBaseAPI = TessBaseAPI()

    val textRegions: List<Rect>
        get() {
            val regions = tessBaseApi.words
            val lineRects = ArrayList(regions.boxRects)
            regions.recycle()
            return lineRects
        }

    /**
     * Initialize tesseract engine.
     *
     * @param language Language code in ISO-639-3 format.
     */
    fun prepareTesseract(
        language: String
    ) {
        //copyTessDataFiles()
        //Log.d("AllowDigitOnly: $allowDigitOnly")
        tessBaseApi.init("", language)
    }

    /**
     * Set image for recognition.
     *
     * @param bitmap Image data.
     */
    fun setBitmap(bitmap: Bitmap, segMode: Int) {
        tessBaseApi.pageSegMode = segMode
        tessBaseApi.setImage(bitmap)
    }

    /**
     * Clear tesseract data.
     */
    fun stop() {
        tessBaseApi.clear()
    }

    fun destroy() {
        tessBaseApi.end()
    }
}