package com.talpa.translate.ocr.result

import android.annotation.SuppressLint
import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.view.KeyEvent
import android.view.View
import android.view.inputmethod.EditorInfo
import android.view.inputmethod.InputMethodManager
import android.widget.TextView
import android.widget.Toast
import androidx.fragment.app.Fragment
import androidx.fragment.app.activityViewModels
import androidx.fragment.app.viewModels
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.navigation.fragment.findNavController
import com.photo.translation.R
import com.photo.translation.databinding.ContrastEditLayoutBinding
import com.talpa.TranslationController
import com.talpa.translate.base.utils.PREFER_KEY_SOURCE_LANG
import com.talpa.translate.base.utils.PREFER_NAME
import com.talpa.translate.base.utils.clipboard
import com.talpa.translate.camera.CameraFragment
import com.talpa.translate.network.HiTranslator
import java.util.*


/**
 * Create by chenjunsheng on 2020/10/15
 */
class ContrastEditFragment : Fragment(R.layout.contrast_edit_layout)/*, TextView.OnEditorActionListener*/, View.OnClickListener {

    private val model: ContrastViewModel by activityViewModels()
    private lateinit var binding: ContrastEditLayoutBinding
    private val sourceLiveData: MutableLiveData<String> = MutableLiveData<String>("en")
    private val targetLiveData: MutableLiveData<String> = MutableLiveData<String>("en")
    private val translateViewModel: TranslateViewModel by viewModels {
        object : ViewModelProvider.Factory {
            override fun <T : ViewModel?> create(modelClass: Class<T>): T {
                return TranslateViewModel() as T
            }

        }
    }

    @SuppressLint("ClickableViewAccessibility")
    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding = ContrastEditLayoutBinding.bind(view)

        model.completeModel.observe(viewLifecycleOwner, Observer {
            val ocrSb = StringBuilder()
            it.ocrResult?.blocks?.forEachIndexed { index, block ->
                ocrSb.append(block.text)
                ocrSb.append("\n")
            }
            if (ocrSb.isNotEmpty()) {
                binding.sourceEdit.setText(ocrSb.dropLast(1))
            }

            val resSb = StringBuilder()
            it.transResponse?.result?.texts?.forEach {
                resSb.append(it)
                resSb.append("\n")
            }
            if (resSb.isNotEmpty()) {
                binding.targetText.setText(resSb.drop(1))
            }
        })
        //binding.sourceEdit.setOnEditorActionListener(this)
        readLanguage()
        binding.sourceCopy.setOnClickListener(this)
        binding.targetCopy.setOnClickListener(this)
        binding.sourceEdit.setOnClickListener {
            binding.contrastEdit.setImageResource(R.drawable.ic_done)
        }


        binding.sourceEdit.setOnFocusChangeListener { v, hasFocus ->
            if (hasFocus) {
                binding.contrastEdit.setImageResource(R.drawable.ic_done)
                binding.contrastEdit.setOnClickListener {
                    if (TextUtils.isEmpty(binding.sourceEdit.text)) {
                        return@setOnClickListener
                    }
                    val texts = binding.sourceEdit.text?.split(Regex("\\n")) ?: return@setOnClickListener
                    startTranslate(texts)
                }
            } else {
                binding.contrastEdit.setOnClickListener {
                    showSoftKeyboard()
                }
            }
        }
        binding.toolbar.setNavigationOnClickListener {
            hideSoftKeyboard()
            findNavController().navigateUp()
        }
    }

    override fun onResume() {
        super.onResume()
        showSoftKeyboard()
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.source_copy -> {
                v.context.clipboard(label = "Contrast", text = binding.sourceEdit.text ?: return)
                Toast.makeText(v.context, R.string.copied_toast_contrast, Toast.LENGTH_SHORT).show()
            }
            R.id.target_copy -> {
                v.context.clipboard(label = "Contrast", text = binding.targetText.text ?: return)
                Toast.makeText(v.context, R.string.copied_toast_contrast, Toast.LENGTH_SHORT).show()
            }
        }
    }

    private fun readLanguage() {
        val prefer = context?.getSharedPreferences(PREFER_NAME, Context.MODE_PRIVATE) ?: return
        val defaultTargetLang = TranslationController.targetLanguage

        val sourceLang =
                prefer.getString(PREFER_KEY_SOURCE_LANG, TranslationController.sourceLanguage)
                        ?: Locale.getDefault().language
        val targetLang =
                prefer.getString(CameraFragment.PREFER_KEY_TARGET_LANG, defaultTargetLang)
                        ?: Locale.getDefault().language
        sourceLiveData.value = sourceLang
        targetLiveData.value = targetLang
    }

    private fun startTranslate(texts: List<String>) {
        binding.loadingProgressBar.visibility = View.VISIBLE
        val from = sourceLiveData.value ?: return
        val to = targetLiveData.value ?: return
        hideSoftKeyboard()
        translateViewModel.startTranslate(context ?: return, from, to, texts).observe(viewLifecycleOwner, Observer {
            binding.loadingProgressBar.visibility = View.GONE
            binding.contrastEdit.setImageResource(R.drawable.ic_contrast_edit)
            if (it.isSuccess) {
                val response = it.getOrNull()
                if (response != null) {
                    val resSb = StringBuilder()
                    response.result?.texts?.let {
                        it.forEachIndexed { index, s ->
                            resSb.append(s)
                            if (index < it.size - 1) {
                                resSb.append("\n")
                            }
                        }
                    }
                    binding.targetText.setText(resSb)
                    /*if (resSb.isNotEmpty()) {
                        binding.targetText.setText(resSb.drop(1))
                    }*/
                } else {
                    Toast.makeText(context ?: return@Observer, R.string.translate_fail, Toast.LENGTH_SHORT).show()
                }
            } else {
                Toast.makeText(context ?: return@Observer, R.string.translate_fail, Toast.LENGTH_SHORT).show()
            }
        })
    }

    private fun hideSoftKeyboard() {
        val activity = activity ?: return
        binding.sourceEdit.clearFocus()
        val focus = binding.sourceEdit
        val imm =
                activity.getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
        imm.hideSoftInputFromWindow(focus.windowToken, 0)
    }

    private fun showSoftKeyboard() {
        binding.sourceEdit.requestFocus()
        val activity = activity ?: return
        val imm =
                activity.getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
        imm.showSoftInput(binding.sourceEdit, 0)
    }

    /*override fun onEditorAction(v: TextView?, actionId: Int, event: KeyEvent?): Boolean {
        return if (actionId == EditorInfo.IME_ACTION_SEND || (event != null && event.keyCode == KeyEvent.KEYCODE_ENTER)) {
            if (event?.action == KeyEvent.ACTION_DOWN) {
                val texts = v?.text?.split(Regex("\\n")) ?: return false
                startTranslate(texts)
            }
            true
        } else {
            false
        }
    }*/


}