/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.picture;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.talpa.translate.camera.view.PictureResult;

public abstract class PictureRecorder {
    @VisibleForTesting(otherwise=4)
    PictureResult.Stub mResult;
    @VisibleForTesting
    PictureResultListener mListener;
    protected Exception mError;

    public PictureRecorder(@NonNull PictureResult.Stub stub, @Nullable PictureResultListener listener) {
        this.mResult = stub;
        this.mListener = listener;
    }

    public abstract void take();

    protected void dispatchOnShutter(boolean didPlaySound) {
        if (this.mListener != null) {
            this.mListener.onPictureShutter(didPlaySound);
        }
    }

    protected void dispatchResult() {
        if (this.mListener != null) {
            this.mListener.onPictureResult(this.mResult, this.mError);
            this.mListener = null;
            this.mResult = null;
        }
    }

    public static interface PictureResultListener {
        public void onPictureShutter(boolean var1);

        public void onPictureResult(@Nullable PictureResult.Stub var1, @Nullable Exception var2);
    }
}

