/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.engine.options;

import android.graphics.ImageFormat;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.talpa.translate.camera.view.CameraOptions;
import com.talpa.translate.camera.view.controls.Facing;
import com.talpa.translate.camera.view.controls.Flash;
import com.talpa.translate.camera.view.controls.Hdr;
import com.talpa.translate.camera.view.controls.PictureFormat;
import com.talpa.translate.camera.view.controls.WhiteBalance;
import com.talpa.translate.camera.view.engine.mappers.Camera2Mapper;
import com.talpa.translate.camera.view.internal.CamcorderProfiles;
import com.talpa.translate.camera.view.size.AspectRatio;
import java.util.Set;

@RequiresApi(value=21)
public class Camera2Options
extends CameraOptions {
    public Camera2Options(@NonNull CameraManager manager, @NonNull String cameraId, boolean flipSizes, int pictureFormat) throws CameraAccessException {
        int[] outputFormats;
        Size[] vsizes;
        Size[] psizes;
        int[] sceneModes;
        int[] awbModes;
        Camera2Mapper mapper = Camera2Mapper.get();
        CameraCharacteristics cameraCharacteristics = manager.getCameraCharacteristics(cameraId);
        for (String cameraId1 : manager.getCameraIdList()) {
            Facing value;
            CameraCharacteristics cameraCharacteristics1 = manager.getCameraCharacteristics(cameraId1);
            Integer cameraFacing = (Integer)cameraCharacteristics1.get(CameraCharacteristics.LENS_FACING);
            if (cameraFacing == null || (value = mapper.unmapFacing(cameraFacing)) == null) continue;
            this.supportedFacing.add(value);
        }
        for (int awbMode : awbModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES)) {
            WhiteBalance value = mapper.unmapWhiteBalance(awbMode);
            if (value == null) continue;
            this.supportedWhiteBalance.add(value);
        }
        this.supportedFlash.add(Flash.OFF);
        Boolean hasFlash = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        if (hasFlash != null && hasFlash.booleanValue()) {
            int[] aeModes;
            for (int aeMode : aeModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES)) {
                Set<Flash> flashes = mapper.unmapFlash(aeMode);
                this.supportedFlash.addAll(flashes);
            }
        }
        this.supportedHdr.add(Hdr.OFF);
        for (int sceneMode : sceneModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_SCENE_MODES)) {
            Hdr value = mapper.unmapHdr(sceneMode);
            if (value == null) continue;
            this.supportedHdr.add(value);
        }
        Float maxZoom = (Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        if (maxZoom != null) {
            this.zoomSupported = maxZoom.floatValue() > 1.0f;
        }
        Integer afRegions = (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
        Integer aeRegions = (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE);
        Integer awbRegions = (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB);
        this.autoFocusSupported = afRegions != null && afRegions > 0 || aeRegions != null && aeRegions > 0 || awbRegions != null && awbRegions > 0;
        Range exposureRange = (Range)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        Rational exposureStep = (Rational)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
        if (exposureRange != null && exposureStep != null && exposureStep.floatValue() != 0.0f) {
            this.exposureCorrectionMinValue = (float)((Integer)exposureRange.getLower()).intValue() / exposureStep.floatValue();
            this.exposureCorrectionMaxValue = (float)((Integer)exposureRange.getUpper()).intValue() / exposureStep.floatValue();
        }
        this.exposureCorrectionSupported = this.exposureCorrectionMinValue != 0.0f && this.exposureCorrectionMaxValue != 0.0f;
        StreamConfigurationMap streamMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (streamMap == null) {
            throw new RuntimeException("StreamConfigurationMap is null. Should not happen.");
        }
        int[] pictureFormats = streamMap.getOutputFormats();
        boolean hasPictureFormat = false;
        for (int picFormat : pictureFormats) {
            if (picFormat != pictureFormat) continue;
            hasPictureFormat = true;
            break;
        }
        if (!hasPictureFormat) {
            throw new IllegalStateException("Picture format not supported: " + pictureFormat);
        }
        for (Size size : psizes = streamMap.getOutputSizes(pictureFormat)) {
            int width = flipSizes ? size.getHeight() : size.getWidth();
            int height = flipSizes ? size.getWidth() : size.getHeight();
            this.supportedPictureSizes.add(new com.talpa.translate.camera.view.size.Size(width, height));
            this.supportedPictureAspectRatio.add(AspectRatio.of(width, height));
        }
        CamcorderProfile profile = CamcorderProfiles.get(cameraId, new com.talpa.translate.camera.view.size.Size(Integer.MAX_VALUE, Integer.MAX_VALUE));
        com.talpa.translate.camera.view.size.Size videoMaxSize = new com.talpa.translate.camera.view.size.Size(profile.videoFrameWidth, profile.videoFrameHeight);
        for (Size size : vsizes = streamMap.getOutputSizes(MediaRecorder.class)) {
            if (size.getWidth() > videoMaxSize.getWidth() || size.getHeight() > videoMaxSize.getHeight()) continue;
            int width = flipSizes ? size.getHeight() : size.getWidth();
            int height = flipSizes ? size.getWidth() : size.getHeight();
            this.supportedVideoSizes.add(new com.talpa.translate.camera.view.size.Size(width, height));
            this.supportedVideoAspectRatio.add(AspectRatio.of(width, height));
        }
        Range[] rangeArray = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        if (rangeArray != null) {
            this.previewFrameRateMinValue = Float.MAX_VALUE;
            this.previewFrameRateMaxValue = -3.4028235E38f;
            for (Range fpsRange : rangeArray) {
                this.previewFrameRateMinValue = Math.min(this.previewFrameRateMinValue, (float)((Integer)fpsRange.getLower()).intValue());
                this.previewFrameRateMaxValue = Math.max(this.previewFrameRateMaxValue, (float)((Integer)fpsRange.getUpper()).intValue());
            }
        } else {
            this.previewFrameRateMinValue = 0.0f;
            this.previewFrameRateMaxValue = 0.0f;
        }
        this.supportedPictureFormats.add(PictureFormat.JPEG);
        int[] caps = (int[])cameraCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        if (caps != null) {
            for (int cap : caps) {
                if (cap != 3) continue;
                this.supportedPictureFormats.add(PictureFormat.DNG);
            }
        }
        this.supportedFrameProcessingFormats.add(35);
        for (int outputFormat : outputFormats = streamMap.getOutputFormats()) {
            if (ImageFormat.getBitsPerPixel((int)outputFormat) <= 0) continue;
            this.supportedFrameProcessingFormats.add(outputFormat);
        }
    }
}

