/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.filters;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.talpa.translate.camera.surface.opengl.core.Egloo;
import com.talpa.translate.camera.view.filter.BaseFilter;
import com.talpa.translate.camera.view.filter.OneParameterFilter;

public class ContrastFilter
extends BaseFilter
implements OneParameterFilter {
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nuniform float contrast;\nvarying vec2 vTextureCoord;\nvoid main() {\n  vec4 color = texture2D(sTexture, vTextureCoord);\n  color -= 0.5;\n  color *= contrast;\n  color += 0.5;\n  gl_FragColor = color;\n}\n";
    private float contrast = 2.0f;
    private int contrastLocation = -1;

    public void setContrast(float contrast) {
        if (contrast < 1.0f) {
            contrast = 1.0f;
        }
        if (contrast > 2.0f) {
            contrast = 2.0f;
        }
        this.contrast = contrast;
    }

    public float getContrast() {
        return this.contrast;
    }

    @Override
    public void setParameter1(float value) {
        this.setContrast(value + 1.0f);
    }

    @Override
    public float getParameter1() {
        return this.getContrast() - 1.0f;
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.contrastLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"contrast");
        Egloo.checkGlProgramLocation(this.contrastLocation, "contrast");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.contrastLocation = -1;
    }

    @Override
    protected void onPreDraw(long timestampUs, @NonNull float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        GLES20.glUniform1f((int)this.contrastLocation, (float)this.contrast);
        Egloo.checkGlError("glUniform1f");
    }
}

