/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.record;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcelable;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import androidx.annotation.RestrictTo;
import com.talpa.PhotoTranslateController;
import com.talpa.translate.activity.ScreenRecordActivity;
import com.talpa.translate.network.HiTranslator;
import com.talpa.translate.network.TransResponse;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import com.talpa.translate.record.CaptureManager;
import com.talpa.translate.record.CaptureManager$delegateRecTouchEvent$;
import com.talpa.translate.record.CaptureResult;
import com.talpa.translate.record.CaptureTransResult;
import com.talpa.translate.record.ICaptureController;
import com.talpa.translate.record.IRecordListener;
import com.talpa.translate.record.IRecordService;
import com.talpa.translate.service.RecordService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0083\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0015\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001cH\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\u001a\u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0016J\u0012\u0010.\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0010\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u000bH\u0017J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u0018H\u0016J \u00103\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u000206H\u0017R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/talpa/translate/record/CaptureManager;", "Landroid/content/ServiceConnection;", "Lcom/talpa/translate/record/ICaptureController;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCaptureJob", "Lkotlinx/coroutines/Job;", "mContext", "kotlin.jvm.PlatformType", "mCurrentState", "", "mLastResult", "Lcom/talpa/translate/record/CaptureTransResult;", "mLastX", "", "mLastY", "mRecognizeJob", "mRecordService", "Lcom/talpa/translate/record/IRecordService;", "mRemoteCallback", "com/talpa/translate/record/CaptureManager$mRemoteCallback$1", "Lcom/talpa/translate/record/CaptureManager$mRemoteCallback$1;", "mResultListener", "Lcom/talpa/PhotoTranslateController$TextRecognizeListener;", "velocityTracker", "Landroid/view/VelocityTracker;", "captureFrameSync", "Lcom/talpa/translate/record/CaptureResult;", "delegateRecTouchEvent", "", "e", "Landroid/view/MotionEvent;", "destroyRecognizeService", "fastAnalyzeArea", "result", "isRectangleOverlap", "", "current", "Landroid/graphics/Rect;", "other", "onServiceConnected", "name", "Landroid/content/ComponentName;", "service", "Landroid/os/IBinder;", "onServiceDisconnected", "setCurrentState", "state", "setTextRecognizeListener", "listener", "startRecordService", "resultCode", "data", "Landroid/content/Intent;", "Companion", "translation_hwRelease"})
public final class CaptureManager
implements ServiceConnection,
ICaptureController {
    private PhotoTranslateController.TextRecognizeListener mResultListener;
    private IRecordService mRecordService;
    private final Context mContext;
    private int mCurrentState;
    private float mLastX;
    private float mLastY;
    private Job mCaptureJob;
    private Job mRecognizeJob;
    private CaptureTransResult mLastResult;
    private VelocityTracker velocityTracker;
    private final mRemoteCallback.1 mRemoteCallback;
    public static final int RECT_GAP = 12;
    public static final int MIN_DISTANCE = 15;
    public static final int STATE_INITIALIZE = 0;
    public static final int STATE_ASKING_PERMISSION = 1;
    public static final int STATE_PERMISSION_GRANTED = 2;
    public static final int STATE_SERVICE_PREPARED = 3;
    public static final int STATE_CAPTURING_PIC = 4;
    public static final int STATE_CAPTURED_PIC = 5;
    public static final int STATE_RECOGNIZE_START = 6;
    public static final int STATE_RECOGNIZING = 7;
    public static final int STATE_TRANSLATING = 8;
    public static final int STATE_RECOGNIZED_FINISH = 9;
    public static final int STATE_TRANSLATE_FINISH = 10;
    public static final int STATE_ACTION_CLEAR = 11;
    private static final int VELOCITY_TIME_MILLIS = 300;
    private static final int MIN_VELOCITY = 80;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void setTextRecognizeListener(@NotNull PhotoTranslateController.TextRecognizeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mResultListener = listener;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setCurrentState(int state) {
        this.mCurrentState = state;
    }

    @Override
    @NotNull
    public CaptureResult captureFrameSync(@NotNull Context context) {
        CaptureResult captureResult;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.mRecordService == null) {
            ScreenRecordActivity.Companion.start(context);
            return new CaptureResult(0, null, null, 6, null);
        }
        try {
            IRecordService iRecordService = this.mRecordService;
            Intrinsics.checkNotNull((Object)iRecordService);
            captureResult = iRecordService.captureFrameSync();
        }
        catch (Exception e) {
            e.printStackTrace();
            captureResult = null;
        }
        CaptureResult captureResult2 = captureResult;
        if (captureResult2 == null) {
            return new CaptureResult(2, null, null, 6, null);
        }
        CaptureResult result = captureResult2;
        this.fastAnalyzeArea(result);
        return result;
    }

    private final boolean isRectangleOverlap(Rect current, Rect other) {
        return current.left < other.right && other.left < current.right && current.top < other.bottom && other.top < current.bottom;
    }

    private final void fastAnalyzeArea(CaptureResult result) {
        if (result.getBitmap() == null) {
            return;
        }
        Object object = result.getOcrResult();
        if (object == null || (object = ((OcrResult)object).getBlocks()) == null || (object = CollectionsKt.toMutableList((Collection)((Collection)object))) == null) {
            return;
        }
        Object list = object;
        if (list.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = (Iterable)list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block block = (Block)element$iv;
            boolean bl = false;
            Rect rect = block.getRect();
            rect.inset(-12, -12);
            int n = 0;
            int n2 = rect.left;
            boolean bl2 = false;
            rect.left = Math.max(n, n2);
            n = 0;
            n2 = rect.top;
            bl2 = false;
            rect.top = Math.max(n, n2);
            Bitmap bitmap2 = result.getBitmap();
            Intrinsics.checkNotNull((Object)bitmap2);
            n = bitmap2.getWidth();
            n2 = rect.right;
            bl2 = false;
            rect.right = Math.min(n, n2);
            Bitmap bitmap3 = result.getBitmap();
            Intrinsics.checkNotNull((Object)bitmap3);
            n = bitmap3.getHeight();
            n2 = rect.bottom;
            bl2 = false;
            rect.bottom = Math.min(n, n2);
        }
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                Rect rect = ((Block)list.get(i)).getRect();
                if (!this.isRectangleOverlap(rect, rect)) continue;
                rect.union(rect);
                list.remove(j);
                --j;
            }
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void startRecordService(@NotNull Context context, int resultCode, @NotNull Intent data) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intent serviceIntent = new Intent(context, RecordService.class);
        serviceIntent.putExtra("project_intent", (Parcelable)data);
        serviceIntent.putExtra("project_code", resultCode);
        context.getApplicationContext().bindService(serviceIntent, (ServiceConnection)this, 1);
    }

    @Override
    public void destroyRecognizeService() {
        IRecordService iRecordService = this.mRecordService;
        if (iRecordService != null) {
            iRecordService.destroyService();
        }
        this.mRecordService = null;
    }

    public void onServiceDisconnected(@Nullable ComponentName name) {
        this.mRecordService = null;
    }

    /*
     * WARNING - void declaration
     */
    public void onServiceConnected(@Nullable ComponentName name, @NotNull IBinder service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        IRecordService iRecordService = IRecordService.Stub.asInterface(service);
        boolean bl = false;
        boolean bl2 = false;
        IRecordService iRecordService2 = iRecordService;
        CaptureManager captureManager = this;
        boolean bl3 = false;
        try {
            void it;
            it.registerListener(this.mRemoteCallback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Unit unit = Unit.INSTANCE;
        captureManager.mRecordService = iRecordService;
        this.setCurrentState(3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void delegateRecTouchEvent(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        VelocityTracker velocityTracker = this.velocityTracker;
        Intrinsics.checkNotNull((Object)velocityTracker);
        velocityTracker.addMovement(e);
        block0 : switch (e.getAction()) {
            case 0: {
                Unit unit;
                Unit unit2;
                this.mLastX = e.getRawX();
                this.mLastY = e.getRawY();
                if (this.mRecordService == null) break;
                Job job = this.mRecognizeJob;
                if (job != null) {
                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                Job job2 = this.mCaptureJob;
                if (job2 != null) {
                    Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.setCurrentState(3);
                break;
            }
            case 2: {
                switch (this.mCurrentState) {
                    case 0: {
                        float f = e.getRawX() - this.mLastX;
                        boolean bl = false;
                        float dx = Math.abs(f);
                        float f2 = e.getRawY() - this.mLastY;
                        boolean bl2 = false;
                        float dy = Math.abs(f2);
                        f2 = dx * dx + dy * dy;
                        bl2 = false;
                        if (!((float)Math.sqrt(f2) > (float)15)) break block0;
                        Context context = this.mContext;
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                        this.captureFrameSync(context);
                        this.setCurrentState(1);
                        break block0;
                    }
                    case 3: {
                        Unit unit;
                        float dy = e.getRawX() - this.mLastX;
                        boolean bl = false;
                        float dx = Math.abs(dy);
                        float f = e.getRawY() - this.mLastY;
                        boolean bl3 = false;
                        dy = Math.abs(f);
                        f = dx * dx + dy * dy;
                        bl3 = false;
                        if (!((float)Math.sqrt(f) > (float)15)) break block0;
                        this.setCurrentState(4);
                        Job job = this.mCaptureJob;
                        if (job != null) {
                            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        this.mCaptureJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int label;
                            final /* synthetic */ CaptureManager this$0;

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)object);
                                        Context context = CaptureManager.access$getMContext$p(this.this$0);
                                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                                        CaptureResult captureResult = this.this$0.captureFrameSync(context);
                                        CaptureTransResult captureTransResult = new CaptureTransResult(captureResult, null, 2, null);
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        CaptureTransResult captureTransResult2 = captureTransResult;
                                        CaptureManager captureManager = this.this$0;
                                        boolean bl3 = false;
                                        boolean bl4 = false;
                                        it.setTransMap((Map<Integer, TransResponse>)new HashMap<K, V>());
                                        Unit unit = Unit.INSTANCE;
                                        CaptureManager.access$setMLastResult$p(captureManager, captureTransResult);
                                        this.label = 1;
                                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                            int label;
                                            final /* synthetic */ delegateRecTouchEvent.1 this$0;

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.this$0.this$0.setCurrentState(5);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }
                                            {
                                                this.this$0 = var1_1;
                                                super(2, continuation);
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                return function2;
                                            }

                                            public final Object invoke(Object object, Object object2) {
                                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            {
                                this.this$0 = captureManager;
                                super(2, continuation);
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                return function2;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        break block0;
                    }
                    case 5: {
                        Unit unit;
                        VelocityTracker velocityTracker2 = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)velocityTracker2);
                        velocityTracker2.computeCurrentVelocity(300);
                        VelocityTracker velocityTracker3 = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)velocityTracker3);
                        float xVelocity = velocityTracker3.getXVelocity();
                        VelocityTracker velocityTracker4 = this.velocityTracker;
                        Intrinsics.checkNotNull((Object)velocityTracker4);
                        float yVelocity = velocityTracker4.getYVelocity();
                        if (!(xVelocity < (float)80) || !(yVelocity < (float)80)) break block0;
                        Object object = this.mLastResult;
                        if (object != null && (object = ((CaptureTransResult)object).getCaptureResult()) != null) {
                            void index;
                            Unit unit3;
                            Object object2 = object;
                            boolean bl = false;
                            boolean bl4 = false;
                            Object result = object2;
                            boolean bl5 = false;
                            Ref.IntRef intRef = new Ref.IntRef();
                            intRef.element = -1;
                            Object object3 = ((CaptureResult)result).getOcrResult();
                            if (object3 != null && (object3 = ((OcrResult)object3).getBlocks()) != null) {
                                Object object4 = object3;
                                boolean bl6 = false;
                                boolean bl7 = false;
                                Object OcrResult2 = object4;
                                boolean bl8 = false;
                                Iterable $this$forEachIndexed$iv = (Iterable)OcrResult2;
                                boolean $i$f$forEachIndexed = false;
                                int index$iv = 0;
                                for (Object item$iv : $this$forEachIndexed$iv) {
                                    void block;
                                    int n = index$iv++;
                                    boolean bl9 = false;
                                    if (n < 0) {
                                        CollectionsKt.throwIndexOverflow();
                                    }
                                    Block block2 = (Block)item$iv;
                                    int i = n;
                                    boolean bl10 = false;
                                    if (!block.getRect().contains((int)e.getRawX(), (int)e.getRawY())) continue;
                                    index.element = i;
                                    break;
                                }
                                unit3 = Unit.INSTANCE;
                            } else {
                                unit3 = null;
                            }
                            if (index.element != -1) {
                                CaptureTransResult captureTransResult = this.mLastResult;
                                Intrinsics.checkNotNull((Object)captureTransResult);
                                captureTransResult.setWorkingIndex(index.element);
                                this.setCurrentState(6);
                                Object object5 = ((CaptureResult)result).getOcrResult();
                                if (object5 == null || (object5 = ((OcrResult)object5).getBlocks()) == null || (object5 = (Block)object5.get(index.element)) == null || (object5 = ((Block)object5).getRect()) == null) {
                                } else {
                                    Unit unit4;
                                    Unit unit5;
                                    Object recognizeRect = object5;
                                    PhotoTranslateController.TextRecognizeListener textRecognizeListener = this.mResultListener;
                                    if (textRecognizeListener != null) {
                                        textRecognizeListener.onAreaConfirmed((Rect)recognizeRect);
                                        unit5 = Unit.INSTANCE;
                                    } else {
                                        unit5 = null;
                                    }
                                    Job job = this.mRecognizeJob;
                                    if (job != null) {
                                        Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                                        unit4 = Unit.INSTANCE;
                                    } else {
                                        unit4 = null;
                                    }
                                    this.mRecognizeJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((CaptureResult)result, (Ref.IntRef)index, (Rect)recognizeRect, null, this, e){
                                        int label;
                                        final /* synthetic */ CaptureResult $result;
                                        final /* synthetic */ Ref.IntRef $index;
                                        final /* synthetic */ Rect $recognizeRect;
                                        final /* synthetic */ CaptureManager this$0;
                                        final /* synthetic */ MotionEvent $e$inlined;
                                        {
                                            this.$result = captureResult;
                                            this.$index = intRef;
                                            this.$recognizeRect = rect;
                                            this.this$0 = captureManager;
                                            this.$e$inlined = motionEvent;
                                            super(2, continuation);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object var1_1) {
                                            block13: {
                                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)var1_1);
                                                        this.this$0.setCurrentState(7);
                                                        targetLanguage = new Ref.ObjectRef();
                                                        v0 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                        if (v0 == null || (v0 = v0.getTransTargetLanguage()) == null) {
                                                            v1 = Locale.ENGLISH;
                                                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"Locale.ENGLISH");
                                                            v0 = v1.getLanguage();
                                                        }
                                                        targetLanguage.element = v0;
                                                        sourceLanguage = new Ref.ObjectRef();
                                                        v2 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                        if (v2 == null || (v2 = v2.getTransSourceLanguage()) == null) {
                                                            v3 = Locale.ENGLISH;
                                                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"Locale.ENGLISH");
                                                            v2 = v3.getLanguage();
                                                        }
                                                        sourceLanguage.element = v2;
                                                        var5_5 = new Ref.ObjectRef();
                                                        v4 = this.$result.getOcrResult();
                                                        var5_5.element = v4 != null && (v4 = v4.getBlocks()) != null ? (Block)CollectionsKt.getOrNull((List)v4, (int)this.$index.element) : null;
                                                        this.this$0.setCurrentState(9);
                                                        if ((Block)ocrResult.element == null) break;
                                                        this.this$0.setCurrentState(8);
                                                        this.label = 1;
                                                        v5 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransResponse>, Object>(this, sourceLanguage, targetLanguage, (Ref.ObjectRef)ocrResult, null){
                                                            int label;
                                                            final /* synthetic */ delegateRecTouchEvent$$inlined$let$lambda$1 this$0;
                                                            final /* synthetic */ Ref.ObjectRef $sourceLanguage;
                                                            final /* synthetic */ Ref.ObjectRef $targetLanguage;
                                                            final /* synthetic */ Ref.ObjectRef $ocrResult;
                                                            {
                                                                this.this$0 = var1_1;
                                                                this.$sourceLanguage = objectRef;
                                                                this.$targetLanguage = objectRef2;
                                                                this.$ocrResult = objectRef3;
                                                                super(2, continuation);
                                                            }

                                                            /*
                                                             * WARNING - void declaration
                                                             * Enabled force condition propagation
                                                             * Lifted jumps to return sites
                                                             */
                                                            @Nullable
                                                            public final Object invokeSuspend(@NotNull Object object) {
                                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                switch (this.label) {
                                                                    case 0: {
                                                                        ResultKt.throwOnFailure((Object)object);
                                                                        Context context = CaptureManager.access$getMContext$p(this.this$0.this$0);
                                                                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                                                                        HiTranslator hiTranslator = HiTranslator.Companion.getInstance(context);
                                                                        String string2 = (String)this.$sourceLanguage.element;
                                                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourceLanguage");
                                                                        String string3 = (String)this.$targetLanguage.element;
                                                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"targetLanguage");
                                                                        this.label = 1;
                                                                        Object object3 = hiTranslator.postTranslateSingle(string2, string3, CollectionsKt.arrayListOf((Object[])new String[]{((Block)this.$ocrResult.element).getText()}), (Continuation<? super TransResponse>)this);
                                                                        Object object4 = object3;
                                                                        if (object3 != object2) return object4;
                                                                        return object2;
                                                                    }
                                                                    case 1: {
                                                                        void $result;
                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                        Object object4 = $result;
                                                                        return object4;
                                                                    }
                                                                }
                                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                            }

                                                            @NotNull
                                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                                Function2<CoroutineScope, Continuation<? super TransResponse>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                                return function2;
                                                            }

                                                            public final Object invoke(Object object, Object object2) {
                                                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                            }
                                                        }), (Continuation)this);
                                                        if (v5 == var2_2) {
                                                            var6_6 = var2_2;
                                                            return var6_6;
                                                        }
                                                        ** GOTO lbl35
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v5 = $result;
lbl35:
                                                        // 2 sources

                                                        transResult = (TransResponse)v5;
                                                        v6 = CaptureManager.access$getMLastResult$p(this.this$0);
                                                        Intrinsics.checkNotNull((Object)v6);
                                                        v6.setWorkingIndex(-1);
                                                        v7 = CaptureManager.access$getMLastResult$p(this.this$0);
                                                        Intrinsics.checkNotNull((Object)v7);
                                                        v8 = v7.getTransMap();
                                                        Intrinsics.checkNotNull(v8);
                                                        v8.put(Boxing.boxInt((int)this.$index.element), transResult);
                                                        v9 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                        if (v9 != null) {
                                                            v10 = this.$index.element;
                                                            v11 = CaptureManager.access$getMLastResult$p(this.this$0);
                                                            Intrinsics.checkNotNull((Object)v11);
                                                            v9.onRecognized(v10, v11);
                                                        }
                                                        if (CaptureManager.access$getMCurrentState$p(this.this$0) == 11) {
                                                            this.this$0.setCurrentState(3);
                                                            CaptureManager.access$setMLastResult$p(this.this$0, null);
                                                        } else {
                                                            this.this$0.setCurrentState(10);
                                                        }
                                                        break block13;
                                                    }
                                                }
                                                if (CaptureManager.access$getMCurrentState$p(this.this$0) == 11) {
                                                    this.this$0.setCurrentState(3);
                                                    CaptureManager.access$setMLastResult$p(this.this$0, null);
                                                } else {
                                                    this.this$0.setCurrentState(10);
                                                }
                                                v12 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                if (v12 != null) {
                                                    v12.onRecognizedFail(this.$recognizeRect);
                                                }
                                            }
                                            return Unit.INSTANCE;
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                            Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                            return function2;
                                        }

                                        public final Object invoke(Object object, Object object2) {
                                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                            }
                            unit = Unit.INSTANCE;
                            break block0;
                        }
                        unit = null;
                        break block0;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        Unit unit;
                        CaptureTransResult captureTransResult = this.mLastResult;
                        if (captureTransResult != null) {
                            CaptureTransResult captureTransResult2 = captureTransResult;
                            boolean bl = false;
                            boolean bl11 = false;
                            CaptureTransResult transResult = captureTransResult2;
                            boolean bl12 = false;
                            VelocityTracker velocityTracker5 = this.velocityTracker;
                            Intrinsics.checkNotNull((Object)velocityTracker5);
                            velocityTracker5.computeCurrentVelocity(300);
                            VelocityTracker velocityTracker6 = this.velocityTracker;
                            Intrinsics.checkNotNull((Object)velocityTracker6);
                            float xVelocity = velocityTracker6.getXVelocity();
                            VelocityTracker velocityTracker7 = this.velocityTracker;
                            Intrinsics.checkNotNull((Object)velocityTracker7);
                            float yVelocity = velocityTracker7.getYVelocity();
                            if (xVelocity < (float)80 && yVelocity < (float)80) {
                                void index;
                                Unit unit6;
                                CaptureResult captureResult = transResult.getCaptureResult();
                                boolean bl13 = false;
                                boolean bl14 = false;
                                CaptureResult captureResult2 = captureResult;
                                boolean bl15 = false;
                                Ref.IntRef bl8 = new Ref.IntRef();
                                bl8.element = -1;
                                Object object = captureResult2.getOcrResult();
                                if (object != null && (object = ((OcrResult)object).getBlocks()) != null) {
                                    Object $this$forEachIndexed$iv = object;
                                    boolean $i$f$forEachIndexed = false;
                                    boolean index$iv = false;
                                    Object blocks = $this$forEachIndexed$iv;
                                    boolean bl16 = false;
                                    Iterable $this$forEachIndexed$iv2 = (Iterable)blocks;
                                    boolean $i$f$forEachIndexed2 = false;
                                    int index$iv2 = 0;
                                    for (Object item$iv : $this$forEachIndexed$iv2) {
                                        void block;
                                        int n = index$iv2++;
                                        boolean bl17 = false;
                                        if (n < 0) {
                                            CollectionsKt.throwIndexOverflow();
                                        }
                                        Block block3 = (Block)item$iv;
                                        int i = n;
                                        boolean bl18 = false;
                                        if (!block.getRect().contains((int)e.getRawX(), (int)e.getRawY())) continue;
                                        index.element = i;
                                        break;
                                    }
                                    unit6 = Unit.INSTANCE;
                                } else {
                                    unit6 = null;
                                }
                                if (index.element != -1 && transResult.getWorkingIndex() != index.element) {
                                    Object object6 = captureResult2.getOcrResult();
                                    if (object6 == null || (object6 = ((OcrResult)object6).getBlocks()) == null || (object6 = (Block)object6.get(index.element)) == null || (object6 = ((Block)object6).getRect()) == null) {
                                    } else {
                                        Object recognizeRect = object6;
                                        Map<Integer, TransResponse> map = transResult.getTransMap();
                                        if ((map != null ? map.get(index.element) : null) != null) {
                                            Unit unit7;
                                            Unit unit8;
                                            transResult.setWorkingIndex(index.element);
                                            PhotoTranslateController.TextRecognizeListener textRecognizeListener = this.mResultListener;
                                            if (textRecognizeListener != null) {
                                                textRecognizeListener.onAreaConfirmed((Rect)recognizeRect);
                                                unit8 = Unit.INSTANCE;
                                            } else {
                                                unit8 = null;
                                            }
                                            PhotoTranslateController.TextRecognizeListener textRecognizeListener2 = this.mResultListener;
                                            if (textRecognizeListener2 != null) {
                                                textRecognizeListener2.onRecognized(index.element, transResult);
                                                unit7 = Unit.INSTANCE;
                                            } else {
                                                unit7 = null;
                                            }
                                        } else {
                                            Unit unit9;
                                            Unit unit10;
                                            transResult.setWorkingIndex(index.element);
                                            PhotoTranslateController.TextRecognizeListener textRecognizeListener = this.mResultListener;
                                            if (textRecognizeListener != null) {
                                                textRecognizeListener.onAreaConfirmed((Rect)recognizeRect);
                                                unit10 = Unit.INSTANCE;
                                            } else {
                                                unit10 = null;
                                            }
                                            Ref.ObjectRef $i$f$forEachIndexed = new Ref.ObjectRef();
                                            Object object7 = this.mResultListener;
                                            if (object7 == null || (object7 = object7.getTransTargetLanguage()) == null) {
                                                Locale locale = Locale.ENGLISH;
                                                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
                                                object7 = locale.getLanguage();
                                            }
                                            $i$f$forEachIndexed.element = object7;
                                            Ref.ObjectRef index$iv = new Ref.ObjectRef();
                                            Object object8 = this.mResultListener;
                                            if (object8 == null || (object8 = object8.getTransSourceLanguage()) == null) {
                                                Locale locale = Locale.ENGLISH;
                                                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
                                                object8 = locale.getLanguage();
                                            }
                                            index$iv.element = object8;
                                            OcrResult ocrResult = transResult.getCaptureResult().getOcrResult();
                                            if (ocrResult != null) {
                                                void targetLanguage;
                                                void sourceLanguage;
                                                Unit unit11;
                                                OcrResult ocrResult2 = ocrResult;
                                                boolean bl19 = false;
                                                boolean bl20 = false;
                                                OcrResult ocrR = ocrResult2;
                                                boolean bl21 = false;
                                                Job job = this.mRecognizeJob;
                                                if (job != null) {
                                                    Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
                                                    unit11 = Unit.INSTANCE;
                                                } else {
                                                    unit11 = null;
                                                }
                                                this.mRecognizeJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ocrR, null, (Ref.ObjectRef)sourceLanguage, (Ref.ObjectRef)targetLanguage, (Ref.IntRef)index, transResult, this, e){
                                                    int label;
                                                    final /* synthetic */ OcrResult $ocrR;
                                                    final /* synthetic */ Ref.ObjectRef $sourceLanguage$inlined;
                                                    final /* synthetic */ Ref.ObjectRef $targetLanguage$inlined;
                                                    final /* synthetic */ Ref.IntRef $index$inlined;
                                                    final /* synthetic */ CaptureTransResult $transResult$inlined;
                                                    final /* synthetic */ CaptureManager this$0;
                                                    final /* synthetic */ MotionEvent $e$inlined;
                                                    {
                                                        this.$ocrR = ocrResult;
                                                        this.$sourceLanguage$inlined = objectRef;
                                                        this.$targetLanguage$inlined = objectRef2;
                                                        this.$index$inlined = intRef;
                                                        this.$transResult$inlined = captureTransResult;
                                                        this.this$0 = captureManager;
                                                        this.$e$inlined = motionEvent;
                                                        super(2, continuation);
                                                    }

                                                    /*
                                                     * Unable to fully structure code
                                                     */
                                                    @Nullable
                                                    public final Object invokeSuspend(@NotNull Object var1_1) {
                                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)var1_1);
                                                                this.this$0.setCurrentState(8);
                                                                this.label = 1;
                                                                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransResponse>, Object>(this, null){
                                                                    int label;
                                                                    final /* synthetic */ delegateRecTouchEvent$$inlined$let$lambda$2 this$0;
                                                                    {
                                                                        this.this$0 = var1_1;
                                                                        super(2, continuation);
                                                                    }

                                                                    /*
                                                                     * WARNING - void declaration
                                                                     * Enabled force condition propagation
                                                                     * Lifted jumps to return sites
                                                                     */
                                                                    @Nullable
                                                                    public final Object invokeSuspend(@NotNull Object object) {
                                                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                        switch (this.label) {
                                                                            case 0: {
                                                                                ResultKt.throwOnFailure((Object)object);
                                                                                Context context = CaptureManager.access$getMContext$p(this.this$0.this$0);
                                                                                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"mContext");
                                                                                HiTranslator hiTranslator = HiTranslator.Companion.getInstance(context);
                                                                                String string2 = (String)this.this$0.$sourceLanguage$inlined.element;
                                                                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sourceLanguage");
                                                                                String string3 = (String)this.this$0.$targetLanguage$inlined.element;
                                                                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"targetLanguage");
                                                                                this.label = 1;
                                                                                Object object3 = hiTranslator.postTranslateSingle(string2, string3, CollectionsKt.arrayListOf((Object[])new String[]{this.this$0.$ocrR.getBlocks().get(this.this$0.$index$inlined.element).getText()}), (Continuation<? super TransResponse>)this);
                                                                                Object object4 = object3;
                                                                                if (object3 != object2) return object4;
                                                                                return object2;
                                                                            }
                                                                            case 1: {
                                                                                void $result;
                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                Object object4 = $result;
                                                                                return object4;
                                                                            }
                                                                        }
                                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                    }

                                                                    @NotNull
                                                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                                        Function2<CoroutineScope, Continuation<? super TransResponse>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                                        return function2;
                                                                    }

                                                                    public final Object invoke(Object object, Object object2) {
                                                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                                    }
                                                                }), (Continuation)this);
                                                                if (v0 == var2_2) {
                                                                    var3_3 = var2_2;
                                                                    return var3_3;
                                                                }
                                                                ** GOTO lbl15
                                                            }
                                                            case 1: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v0 = $result;
lbl15:
                                                                // 2 sources

                                                                transR = (TransResponse)v0;
                                                                this.this$0.setCurrentState(10);
                                                                v1 = this.$transResult$inlined.getTransMap();
                                                                Intrinsics.checkNotNull(v1);
                                                                v1.put(Boxing.boxInt((int)this.$index$inlined.element), transR);
                                                                v2 = CaptureManager.access$getMResultListener$p(this.this$0);
                                                                if (v2 != null) {
                                                                    v2.onRecognized(this.$index$inlined.element, this.$transResult$inlined);
                                                                }
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    @NotNull
                                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                        return function2;
                                                    }

                                                    public final Object invoke(Object object, Object object2) {
                                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }), (int)3, null);
                                                unit9 = Unit.INSTANCE;
                                            } else {
                                                unit9 = null;
                                            }
                                        }
                                    }
                                }
                            }
                            unit = Unit.INSTANCE;
                            break block0;
                        }
                        unit = null;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                Unit unit;
                if (this.mRecordService != null) {
                    switch (this.mCurrentState) {
                        case 10: {
                            this.setCurrentState(3);
                            this.mLastResult = null;
                            break;
                        }
                        case 4: 
                        case 7: 
                        case 8: {
                            this.setCurrentState(11);
                            break;
                        }
                    }
                } else {
                    this.setCurrentState(0);
                }
                VelocityTracker velocityTracker8 = this.velocityTracker;
                if (velocityTracker8 != null) {
                    velocityTracker8.recycle();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                this.velocityTracker = null;
                break;
            }
        }
    }

    public CaptureManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mContext = context.getApplicationContext();
        this.mRemoteCallback = new IRecordListener.Stub(this){
            final /* synthetic */ CaptureManager this$0;

            public void onRecordServiceReady() {
                block0: {
                    PhotoTranslateController.TextRecognizeListener textRecognizeListener = CaptureManager.access$getMResultListener$p(this.this$0);
                    if (textRecognizeListener == null) break block0;
                    textRecognizeListener.onRecognizeServiceReady();
                }
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public static final /* synthetic */ Context access$getMContext$p(CaptureManager $this) {
        return $this.mContext;
    }

    public static final /* synthetic */ CaptureTransResult access$getMLastResult$p(CaptureManager $this) {
        return $this.mLastResult;
    }

    public static final /* synthetic */ void access$setMLastResult$p(CaptureManager $this, CaptureTransResult captureTransResult) {
        $this.mLastResult = captureTransResult;
    }

    public static final /* synthetic */ PhotoTranslateController.TextRecognizeListener access$getMResultListener$p(CaptureManager $this) {
        return $this.mResultListener;
    }

    public static final /* synthetic */ void access$setMResultListener$p(CaptureManager $this, PhotoTranslateController.TextRecognizeListener textRecognizeListener) {
        $this.mResultListener = textRecognizeListener;
    }

    public static final /* synthetic */ int access$getMCurrentState$p(CaptureManager $this) {
        return $this.mCurrentState;
    }

    public static final /* synthetic */ void access$setMCurrentState$p(CaptureManager $this, int n) {
        $this.mCurrentState = n;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/talpa/translate/record/CaptureManager$Companion;", "", "()V", "MIN_DISTANCE", "", "MIN_VELOCITY", "RECT_GAP", "STATE_ACTION_CLEAR", "STATE_ASKING_PERMISSION", "STATE_CAPTURED_PIC", "STATE_CAPTURING_PIC", "STATE_INITIALIZE", "STATE_PERMISSION_GRANTED", "STATE_RECOGNIZED_FINISH", "STATE_RECOGNIZE_START", "STATE_RECOGNIZING", "STATE_SERVICE_PREPARED", "STATE_TRANSLATE_FINISH", "STATE_TRANSLATING", "VELOCITY_TIME_MILLIS", "translation_hwRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

