/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.base.utils;

import android.app.ActivityManager;
import android.view.View;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.photo.translation.R;

public class AntiShakeUtils {
    private static final long INTERNAL_TIME = 500L;

    public static boolean isInvalidClick(@NonNull View target) {
        if (ActivityManager.isUserAMonkey()) {
            return AntiShakeUtils.isInvalidClick(target, 1000L);
        }
        return AntiShakeUtils.isInvalidClick(target, 500L);
    }

    public static boolean isInvalidClick(@NonNull View target, @IntRange(from=0L) long internalTime) {
        boolean isInvalid;
        long curTimeStamp = System.currentTimeMillis();
        long lastClickTimeStamp = 0L;
        Object time = target.getTag(R.id.last_click_time_camera);
        if (time == null) {
            target.setTag(R.id.last_click_time_camera, (Object)curTimeStamp);
            return false;
        }
        lastClickTimeStamp = (Long)time;
        boolean bl = isInvalid = curTimeStamp - lastClickTimeStamp < internalTime;
        if (!isInvalid) {
            target.setTag(R.id.last_click_time_camera, (Object)curTimeStamp);
        }
        return isInvalid;
    }
}

