/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.video.encoding;

import android.opengl.Matrix;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.talpa.translate.camera.surface.opengl.core.EglCore;
import com.talpa.translate.camera.surface.opengl.surface.EglWindowSurface;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.filter.Filter;
import com.talpa.translate.camera.view.internal.GlTextureDrawer;
import com.talpa.translate.camera.view.internal.Pool;
import com.talpa.translate.camera.view.video.encoding.EncoderThread;
import com.talpa.translate.camera.view.video.encoding.MediaEncoderEngine;
import com.talpa.translate.camera.view.video.encoding.TextureConfig;
import com.talpa.translate.camera.view.video.encoding.VideoMediaEncoder;

@RequiresApi(api=18)
public class TextureMediaEncoder
extends VideoMediaEncoder<TextureConfig> {
    private static final String TAG = TextureMediaEncoder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    public static final String FRAME_EVENT = "frame";
    public static final String FILTER_EVENT = "filter";
    private int mTransformRotation;
    private EglCore mEglCore;
    private EglWindowSurface mWindow;
    private GlTextureDrawer mDrawer;
    private Pool<Frame> mFramePool = new Pool<Frame>(Integer.MAX_VALUE, new Pool.Factory<Frame>(){

        @Override
        public Frame create() {
            return new Frame();
        }
    });
    private long mFirstTimeUs = Long.MIN_VALUE;

    public TextureMediaEncoder(@NonNull TextureConfig config) {
        super(config.copy());
    }

    @NonNull
    public Frame acquireFrame() {
        if (this.mFramePool.isEmpty()) {
            throw new RuntimeException("Need more frames than this! Please increase the pool size.");
        }
        return this.mFramePool.get();
    }

    @Override
    @EncoderThread
    protected void onPrepare(@NonNull MediaEncoderEngine.Controller controller, long maxLengthUs) {
        this.mTransformRotation = ((TextureConfig)this.mConfig).rotation;
        ((TextureConfig)this.mConfig).rotation = 0;
        super.onPrepare(controller, maxLengthUs);
        this.mEglCore = new EglCore(((TextureConfig)this.mConfig).eglContext, 1);
        this.mWindow = new EglWindowSurface(this.mEglCore, this.mSurface, true);
        this.mWindow.makeCurrent();
        this.mDrawer = new GlTextureDrawer(((TextureConfig)this.mConfig).textureId);
    }

    @Override
    protected boolean shouldRenderFrame(long timestampUs) {
        if (!super.shouldRenderFrame(timestampUs)) {
            LOG.i("shouldRenderFrame - Dropping frame because of super()");
            return false;
        }
        if (this.mFrameNumber <= 10) {
            return true;
        }
        if (this.getPendingEvents(FRAME_EVENT) > 2) {
            LOG.i("shouldRenderFrame - Dropping, we already have too many pending events:", this.getPendingEvents(FRAME_EVENT));
            return false;
        }
        return true;
    }

    @Override
    @EncoderThread
    protected void onEvent(@NonNull String event, @Nullable Object data) {
        switch (event) {
            case "filter": {
                this.onFilter((Filter)data);
                break;
            }
            case "frame": {
                this.onFrame((Frame)data);
            }
        }
    }

    private void onFilter(@NonNull Filter filter) {
        this.mDrawer.setFilter(filter);
    }

    private void onFrame(@NonNull Frame frame) {
        if (!this.shouldRenderFrame(frame.timestampUs())) {
            this.mFramePool.recycle(frame);
            return;
        }
        if (this.mFrameNumber == 1) {
            this.notifyFirstFrameMillis(frame.timestampMillis);
        }
        if (this.mFirstTimeUs == Long.MIN_VALUE) {
            this.mFirstTimeUs = frame.timestampUs();
        }
        if (!this.hasReachedMaxLength()) {
            boolean didReachMaxLength;
            boolean bl = didReachMaxLength = frame.timestampUs() - this.mFirstTimeUs > this.getMaxLengthUs();
            if (didReachMaxLength) {
                LOG.w("onEvent -", "frameNumber:", this.mFrameNumber, "timestampUs:", frame.timestampUs(), "firstTimeUs:", this.mFirstTimeUs, "- reached max length! deltaUs:", frame.timestampUs() - this.mFirstTimeUs);
                this.notifyMaxLengthReached();
            }
        }
        LOG.i("onEvent -", "frameNumber:", this.mFrameNumber, "timestampUs:", frame.timestampUs(), "hasReachedMaxLength:", this.hasReachedMaxLength(), "thread:", Thread.currentThread(), "- draining.");
        this.drainOutput(false);
        LOG.i("onEvent -", "frameNumber:", this.mFrameNumber, "timestampUs:", frame.timestampUs(), "hasReachedMaxLength:", this.hasReachedMaxLength(), "thread:", Thread.currentThread(), "- drawing.");
        float[] transform = frame.transform;
        float scaleX = ((TextureConfig)this.mConfig).scaleX;
        float scaleY = ((TextureConfig)this.mConfig).scaleY;
        float scaleTranslX = (1.0f - scaleX) / 2.0f;
        float scaleTranslY = (1.0f - scaleY) / 2.0f;
        Matrix.translateM((float[])transform, (int)0, (float)scaleTranslX, (float)scaleTranslY, (float)0.0f);
        Matrix.scaleM((float[])transform, (int)0, (float)scaleX, (float)scaleY, (float)1.0f);
        Matrix.translateM((float[])transform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
        Matrix.rotateM((float[])transform, (int)0, (float)this.mTransformRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.translateM((float[])transform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        if (((TextureConfig)this.mConfig).hasOverlay()) {
            ((TextureConfig)this.mConfig).overlayDrawer.draw(((TextureConfig)this.mConfig).overlayTarget);
            Matrix.translateM((float[])((TextureConfig)this.mConfig).overlayDrawer.getTransform(), (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
            Matrix.rotateM((float[])((TextureConfig)this.mConfig).overlayDrawer.getTransform(), (int)0, (float)((TextureConfig)this.mConfig).overlayRotation, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.translateM((float[])((TextureConfig)this.mConfig).overlayDrawer.getTransform(), (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        }
        LOG.i("onEvent -", "frameNumber:", this.mFrameNumber, "timestampUs:", frame.timestampUs(), "hasReachedMaxLength:", this.hasReachedMaxLength(), "thread:", Thread.currentThread(), "- gl rendering.");
        this.mDrawer.setTextureTransform(transform);
        this.mDrawer.draw(frame.timestampUs());
        if (((TextureConfig)this.mConfig).hasOverlay()) {
            ((TextureConfig)this.mConfig).overlayDrawer.render(frame.timestampUs());
        }
        this.mWindow.setPresentationTime(frame.timestampNanos);
        this.mWindow.swapBuffers();
        this.mFramePool.recycle(frame);
        LOG.i("onEvent -", "frameNumber:", this.mFrameNumber, "timestampUs:", frame.timestampUs(), "hasReachedMaxLength:", this.hasReachedMaxLength(), "thread:", Thread.currentThread(), "- gl rendered.");
    }

    @Override
    protected void onStopped() {
        super.onStopped();
        this.mFramePool.clear();
        if (this.mWindow != null) {
            this.mWindow.release();
            this.mWindow = null;
        }
        if (this.mDrawer != null) {
            this.mDrawer.release();
            this.mDrawer = null;
        }
        if (this.mEglCore != null) {
            this.mEglCore.release();
            this.mEglCore = null;
        }
    }

    public static class Frame {
        public long timestampNanos;
        public long timestampMillis;
        public float[] transform = new float[16];

        private Frame() {
        }

        private long timestampUs() {
            return this.timestampNanos / 1000L;
        }
    }
}

