/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.ocr;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.SparseArray;
import com.huawei.hms.mlsdk.common.MLFrame;
import com.huawei.hms.mlsdk.text.MLText;
import com.huawei.hms.mlsdk.text.MLTextAnalyzer;
import com.talpa.translate.base.common.FrameMetadata;
import com.talpa.translate.ocr.Recognizer;
import com.talpa.translate.ocr.datasource.TransParams;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lcom/talpa/translate/ocr/FirebaseRecognizer;", "Lcom/talpa/translate/ocr/Recognizer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "mHistory", "Lcom/talpa/translate/ocr/result/OcrResult;", "mTransParams", "Lcom/talpa/translate/ocr/datasource/TransParams;", "doOcr", "sourceBitmap", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFrameMetadata", "Lcom/talpa/translate/base/common/FrameMetadata;", "getHistory", "getType", "", "setup", "", "transparams", "translation_hwRelease"})
public final class FirebaseRecognizer
implements Recognizer {
    private TransParams mTransParams;
    private OcrResult mHistory;
    @NotNull
    private final Context context;

    @Override
    public void setup(@NotNull TransParams transparams) {
        Intrinsics.checkNotNullParameter((Object)transparams, (String)"transparams");
        this.mTransParams = transparams;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object doOcr(@NotNull Bitmap sourceBitmap, @NotNull Continuation<? super OcrResult> $completion) {
        MLFrame frame = MLFrame.fromBitmap((Bitmap)sourceBitmap);
        MLTextAnalyzer.Factory factory = new MLTextAnalyzer.Factory(this.context);
        TransParams transParams = this.mTransParams;
        if (transParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTransParams");
        }
        MLTextAnalyzer analyzer = factory.setLanguage(transParams.getRecognizeLanguage()).setLocalOCRMode(1).create();
        SparseArray blocks = analyzer.analyseFrame(frame);
        boolean bl = false;
        ArrayList<Block> myBlocks = new ArrayList<Block>();
        SparseArray sparseArray = blocks;
        Intrinsics.checkNotNullExpressionValue((Object)sparseArray, (String)"blocks");
        SparseArray $this$forEach$iv = sparseArray;
        boolean $i$f$forEach = false;
        int n = 0;
        int n2 = $this$forEach$iv.size();
        while (n < n2) {
            void value;
            void index$iv;
            MLText.Block block = (MLText.Block)$this$forEach$iv.valueAt((int)index$iv);
            int $noName_0 = ((Number)Boxing.boxInt((int)$this$forEach$iv.keyAt((int)index$iv))).intValue();
            boolean bl2 = false;
            void v3 = value;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"value");
            Rect rect = v3.getBorder();
            int left = rect.left;
            int top = rect.top;
            int right = rect.right;
            int bottom = rect.bottom;
            if (right >= sourceBitmap.getWidth()) {
                rect.right = sourceBitmap.getWidth() - 1;
            }
            if (bottom >= sourceBitmap.getHeight()) {
                rect.bottom = sourceBitmap.getHeight() - 1;
            }
            if (left <= 0) {
                rect.left = 1;
            }
            if (top <= 0) {
                rect.top = 1;
            }
            if (rect.width() > 0 && rect.height() > 0) {
                String string2 = value.getStringValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.stringValue");
                CharSequence charSequence = string2;
                Regex regex = new Regex("\\n");
                String string3 = " ";
                boolean bl3 = false;
                String replacement = regex.replace(charSequence, string3);
                Block myBlock = new Block(replacement, new Rect(rect));
                myBlocks.add(myBlock);
            }
            ++index$iv;
        }
        analyzer.stop();
        OcrResult ocrResult = this.mHistory = new OcrResult((List<Block>)myBlocks);
        Intrinsics.checkNotNull((Object)ocrResult);
        return ocrResult;
    }

    @Override
    @Nullable
    public FrameMetadata getFrameMetadata() {
        TransParams transParams = this.mTransParams;
        if (transParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTransParams");
        }
        return transParams.getMetaData();
    }

    @Override
    @Nullable
    public OcrResult getHistory() {
        return this.mHistory;
    }

    @Override
    public int getType() {
        return 0;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public FirebaseRecognizer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }
}

