package com.talpa.translate.base.view

import android.content.Context
import android.graphics.Rect
import android.util.AttributeSet
import android.util.Log
import android.view.View
import android.view.View.MeasureSpec.AT_MOST
import androidx.annotation.Keep
import androidx.recyclerview.widget.LinearLayoutManager
import com.photo.translation.R

/**
 * Create by chenjunsheng on 2021/3/18
 */
@Keep
class MaxHeightLLManager @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet?, defStyleAttr: Int = 0,
    defStyleRes: Int = 0
) : LinearLayoutManager(context, attrs, defStyleAttr, defStyleRes) {

    private val maxHeight: Int

    init {
        val a = context.obtainStyledAttributes(
            attrs, R.styleable.MaxHeightLLManager,
            defStyleAttr, defStyleRes
        )
        maxHeight = a.getDimensionPixelOffset(R.styleable.MaxHeightLLManager_manager_maxHeight, 0)
        a.recycle()
    }

    override fun setMeasuredDimension(childrenBounds: Rect, wSpec: Int, hSpec: Int) {
        super.setMeasuredDimension(
            childrenBounds, wSpec, View.MeasureSpec.makeMeasureSpec(
                maxHeight,
                AT_MOST
            )
        )
    }
}