package com.talpa.translate.ocr.result

import android.annotation.SuppressLint
import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.view.View
import android.view.inputmethod.InputMethodManager
import android.widget.Toast
import androidx.core.widget.doAfterTextChanged
import androidx.fragment.app.Fragment
import androidx.fragment.app.viewModels
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import com.photo.translation.R
import com.photo.translation.databinding.ContrastEditLayoutBinding
import com.talpa.PhotoTranslateController
import com.talpa.translate.base.utils.*
import com.talpa.translate.camera.COMPLETE_RESULT
import com.talpa.translate.camera.CameraFragment
import com.talpa.translate.camera.CameraFragment.Companion.PREFER_KEY_TARGET_LANG
import com.talpa.translate.ocr.datasource.CompleteResult
import java.util.*


/**
 * Create by chenjunsheng on 2020/10/15
 */
class ContrastEditFragment : Fragment(R.layout.contrast_edit_layout), View.OnClickListener {

    private lateinit var binding: ContrastEditLayoutBinding
    private val sourceLiveData: MutableLiveData<String> = MutableLiveData<String>("en")
    private val targetLiveData: MutableLiveData<String> = MutableLiveData<String>("en")
    private val translateViewModel: TranslateViewModel by viewModels {
        object : ViewModelProvider.Factory {
            override fun <T : ViewModel?> create(modelClass: Class<T>): T {
                return TranslateViewModel() as T
            }

        }
    }

    private var completeResult: CompleteResult? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val completeTransfer = arguments?.getBinder(COMPLETE_RESULT) as? CompleteTransfer
        completeResult = completeTransfer?.completeResult
    }

    @SuppressLint("ClickableViewAccessibility")
    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding = ContrastEditLayoutBinding.bind(view)
        completeResult?.let {
            val ocrSb = StringBuilder()
            val originSize = it.ocrResult?.blocks?.size ?: 0
            val transSize = it.transResponse?.result?.texts?.size ?: 0
            it.ocrResult?.blocks?.forEachIndexed { index, block ->
                ocrSb.append(block.text)
                if (index < originSize - 1) {
                    ocrSb.append("\n")
                }
            }
            binding.sourceEdit.setText(ocrSb)

            val resSb = StringBuilder()
            it.transResponse?.result?.texts?.forEachIndexed { index, s ->
                resSb.append(s)
                if (index < transSize - 1) {
                    resSb.append("\n")
                }
            }
            binding.targetText.setText(resSb)
        }
        //binding.sourceEdit.setOnEditorActionListener(this)
        readLanguage()
        binding.sourceCopy.setOnClickListener(this)
        binding.targetCopy.setOnClickListener(this)
        binding.sourceEdit.setOnClickListener {
            binding.contrastEdit.setImageResource(R.drawable.source_edit_selector)
        }

        binding.sourceEdit.doAfterTextChanged {
            if (binding.sourceEdit.hasFocus()) {
                binding.contrastEdit.isEnabled = !it.isNullOrEmpty()
            }
        }

        binding.sourceEdit.setOnFocusChangeListener { v, hasFocus ->
            if (hasFocus) {
                binding.contrastEdit.setImageResource(R.drawable.source_edit_selector)
                binding.contrastEdit.setOnClickListener {
                    if (TextUtils.isEmpty(binding.sourceEdit.text)) {
                        return@setOnClickListener
                    }
                    val texts =
                            binding.sourceEdit.text?.split(Regex("\\n"))
                                    ?: return@setOnClickListener
                    startTranslate(texts)
                    logEvent(PT_edit_start_translate, hashMapOf("language" to "${sourceLiveData.value}-${targetLiveData.value}"))
                }
            } else {
                binding.contrastEdit.setOnClickListener {
                    showSoftKeyboard()
                    logEvent(PT_edit_edit)
                }
            }
        }
        binding.toolbar.setNavigationOnClickListener {
            hideSoftKeyboard()
            //findNavController().navigateUp()
            activity?.finish()
        }
    }

    override fun onResume() {
        super.onResume()
        showSoftKeyboard()
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.source_copy -> {
                v.context.clipboard(label = "Contrast", text = binding.sourceEdit.text ?: return)
                Toast.makeText(v.context, R.string.copied_toast_contrast, Toast.LENGTH_SHORT).show()
                logEvent(PT_edit_copy, hashMapOf("type" to "1"))
            }
            R.id.target_copy -> {
                v.context.clipboard(label = "Contrast", text = binding.targetText.text ?: return)
                Toast.makeText(v.context, R.string.copied_toast_contrast, Toast.LENGTH_SHORT).show()
                //logEvent(PT_edit_copy)
                logEvent(PT_edit_copy, hashMapOf("type" to "2"))
            }
        }
    }

    private fun readLanguage() {
        val prefer = context?.getSharedPreferences(PREFER_NAME, Context.MODE_PRIVATE) ?: return
        //val defaultTargetLang = PhotoTranslateController.targetLanguage

        var sourceLang =
                prefer.getString(PREFER_KEY_SOURCE_LANG, Locale.ENGLISH.language)
                        ?: Locale.ENGLISH.language
        if (!ENG_SEQUENCE.contains(sourceLang)) {
            sourceLang = Locale.ENGLISH.language
        }
        val targetLang =
                prefer.getString(PREFER_KEY_TARGET_LANG, Locale.getDefault().language)
                        ?: Locale.getDefault().language
        sourceLiveData.value = sourceLang
        targetLiveData.value = targetLang
    }

    private fun startTranslate(texts: List<String>) {
        binding.loadingProgressBar.visibility = View.VISIBLE
        val from = sourceLiveData.value ?: return
        val to = targetLiveData.value ?: return
        hideSoftKeyboard()
        translateViewModel.startTranslate(context ?: return, from, to, texts)
                .observe(viewLifecycleOwner, Observer {
                    binding.loadingProgressBar.visibility = View.GONE
                    binding.contrastEdit.setImageResource(R.drawable.ic_contrast_edit)
                    val context = context ?: return@Observer
                    if (!context.isNetworkConnected()) {
                        Toast.makeText(context, R.string.network_unavailable, Toast.LENGTH_SHORT).show()
                    }
                    if (it.isSuccess) {
                        val response = it.getOrNull()
                        if (response != null) {
                            val resSb = StringBuilder()
                            response.result?.texts?.let {
                                it.forEachIndexed { index, s ->
                                    resSb.append(s)
                                    if (index < it.size - 1) {
                                        resSb.append("\n")
                                    }
                                }
                            }
                            binding.targetText.setText(resSb)
                            /*if (resSb.isNotEmpty()) {
                                binding.targetText.setText(resSb.drop(1))
                            }*/
                            logEvent(PT_edit_translate_success, hashMapOf("language" to "${sourceLiveData.value}-${targetLiveData.value}"))
                        } else {
                            Toast.makeText(context, R.string.translate_fail, Toast.LENGTH_SHORT).show()
                            logEvent(PT_edit_translate_failure, hashMapOf("language" to "${sourceLiveData.value}-${targetLiveData.value}"))
                        }
                    } else {
                        Toast.makeText(context, R.string.translate_fail, Toast.LENGTH_SHORT).show()
                        logEvent(PT_edit_translate_failure, hashMapOf("language" to "${sourceLiveData.value}-${targetLiveData.value}"))
                    }
                })
    }

    private fun hideSoftKeyboard() {
        val activity = activity ?: return
        binding.sourceEdit.clearFocus()
        val focus = binding.sourceEdit
        val imm =
                activity.getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
        imm.hideSoftInputFromWindow(focus.windowToken, 0)
    }

    private fun showSoftKeyboard() {
        binding.sourceEdit.requestFocus()
        val activity = activity ?: return
        val imm =
                activity.getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
        imm.showSoftInput(binding.sourceEdit, 0)
    }

    /*override fun onEditorAction(v: TextView?, actionId: Int, event: KeyEvent?): Boolean {
        return if (actionId == EditorInfo.IME_ACTION_SEND || (event != null && event.keyCode == KeyEvent.KEYCODE_ENTER)) {
            if (event?.action == KeyEvent.ACTION_DOWN) {
                val texts = v?.text?.split(Regex("\\n")) ?: return false
                startTranslate(texts)
            }
            true
        } else {
            false
        }
    }*/


}