package com.talpa.translate.base.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;

import androidx.annotation.Nullable;

import com.google.firebase.ml.vision.common.FirebaseVisionImageMetadata;
import com.talpa.translate.base.common.FrameMetadata;
import com.talpa.translate.camera.view.controls.Facing;

import org.jetbrains.annotations.NotNull;

import java.io.ByteArrayOutputStream;

/**
 * Utils functions for bitmap conversions.
 */
public class BitmapUtils {

    // Convert NV21 format byte buffer to bitmap.

    // Rotates a bitmap if it is converted from a bytebuffer.
    public static Bitmap rotateBitmap(@NotNull Bitmap bitmap, int rotation) {
        Matrix matrix = new Matrix();
        matrix.postRotate(rotation);
        Bitmap resizedBitmap = Bitmap.createBitmap(bitmap, 0, 0,
                bitmap.getWidth(), bitmap.getHeight(), matrix, true);

        return resizedBitmap;

    }

    // Rotates a bitmap if it is converted from a bytebuffer.

    public static Bitmap scaleBitmapDown(Bitmap bitmap, int maxDimension) {

        int originalWidth = bitmap.getWidth();
        int originalHeight = bitmap.getHeight();
        int resizedWidth = maxDimension;
        int resizedHeight = maxDimension;

        if (originalHeight > originalWidth) {
            resizedHeight = maxDimension;
            resizedWidth = (int) (resizedHeight * (float) originalWidth / (float) originalHeight);
        } else if (originalWidth > originalHeight) {
            resizedWidth = maxDimension;
            resizedHeight = (int) (resizedWidth * (float) originalHeight / (float) originalWidth);
        } else if (originalHeight == originalWidth) {
            resizedHeight = maxDimension;
            resizedWidth = maxDimension;
        }
        return Bitmap.createScaledBitmap(bitmap, resizedWidth, resizedHeight, false);
    }
}



