package com.talpa.translate.ocr.text

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Canvas
import android.graphics.Paint
import android.text.Layout
import android.text.StaticLayout
import android.text.TextPaint
import android.util.TypedValue
import com.talpa.translate.base.common.FrameMetadata
import com.talpa.translate.base.utils.MAX_TEXT_SIZE
import com.talpa.translate.base.utils.getAutofitTextSize
import com.talpa.translate.ocr.TextDrawer
import com.talpa.translate.ocr.datasource.RenderSource
import com.talpa.translate.ocr.result.OcrResult

/**
 * Create by chenjunsheng on 2020/8/4
 */
class NormalTextDrawer(val context: Context) : TextDrawer {

    private var mTextPaint: TextPaint = TextPaint(Paint.ANTI_ALIAS_FLAG)

    /*init {
        mTextPaint.color = Color.BLACK
    }*/

    override fun draw(
        renderSource: RenderSource,
        frameMetadata: FrameMetadata,
        ocrResult: OcrResult,
        transResult: List<String?>
    ): Bitmap? {
        return handleVisionTextToBitmap(renderSource, ocrResult, frameMetadata, transResult)
    }

    /**
     * Vision Text To Bitmap
     */
    private fun handleVisionTextToBitmap(
        renderSource: RenderSource,
        ocrResult: OcrResult,
        metadata: FrameMetadata,
        transResult: List<String?>
    ): Bitmap? {

        /*val newBitmap = Bitmap.createBitmap(
            metadata.width, metadata.height,
            Bitmap.Config.ARGB_8888
        )*/
        //newBitmap.setHasAlpha(true)
        renderSource.bitmap ?: return null

        val canvas = Canvas(renderSource.bitmap!!)
        //canvas.drawColor(Color.TRANSPARENT, PorterDuff.Mode.CLEAR)

        //canvas.drawBitmap(bitmap, 0f, 0f, null)

        //canvas.drawRect()
        //val backgroundPaint = Paint()
        //backgroundPaint.color = Color.WHITE

        //val textPaint = TextPaint(Paint.ANTI_ALIAS_FLAG)
        //    .also { it.density = context.resources.displayMetrics.density }
        //textPaint.color = Color.BLACK
        //textPaint.textAlign = Paint.Align.LEFT

        ocrResult.blocks.forEachIndexed { index, block ->
            mTextPaint.color = renderSource.colors[index]
            val rect = block.rect
            /*val bit = createBlockView(
                context,
                rect,
                transResult.getOrNull(index) ?: return@forEachIndexed
            ) ?: return@forEachIndexed*/
            val textSize = getAutofitTextSize(
                transResult[index] ?: "",
                mTextPaint,
                rect,
                MAX_TEXT_SIZE,
                context
            )
            mTextPaint.textSize = TypedValue.applyDimension(
                TypedValue.COMPLEX_UNIT_SP, textSize.toFloat(),
                context.resources.displayMetrics
            )
            val staticLayout = StaticLayout(
                transResult[index] ?: "",
                mTextPaint, rect.width(),
                Layout.Alignment.ALIGN_NORMAL,
                1.0f,
                0.0f,
                true
            )

            canvas.save()
            canvas.translate(rect.left.toFloat(), rect.top.toFloat())

            staticLayout.draw(canvas)
            //canvas.drawBitmap(bit, rect.left.toFloat(), rect.top.toFloat(), null)
            canvas.restore()

        }

        //val blockFrame = block.boundingBox
        return renderSource.bitmap
    }

}