package com.talpa.translate.render

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Rect
import android.util.Log
import com.talpa.translate.base.utils.BitmapUtils
import com.talpa.translate.ocr.IAnalyzer
import com.talpa.translate.ocr.Recognizer
import com.talpa.translate.ocr.datasource.RenderSource


/**
 * Create by chenjunsheng on 2020/7/14
 */
class TranslatorRender(val context: Context, private val photoAnalyzer: IAnalyzer) : Render {

    override fun analyzeOcrResult(bitmap: Bitmap, translator: Recognizer): RenderSource {
        val rotation = translator.getFrameMetadata()!!.rotation
        val resizeBitmap = BitmapUtils.rotateBitmap(
            bitmap,
            rotation
        )
        photoAnalyzer.initialize(resizeBitmap)
        val ocrResult = checkNotNull(translator.getHistory())
        val rects = arrayListOf<Rect>()
        ocrResult.blocks.forEach {
            rects.add(it.rect)
        }

        val colors = photoAnalyzer.analyzeTextColor(rects.toTypedArray())
        val background = photoAnalyzer.postAnalyzeArea(rects.toTypedArray())
        Log.d("cjslog", "bitmap recycle:${bitmap.isRecycled}")
        photoAnalyzer.release()
        resizeBitmap.recycle()
        return RenderSource(background, colors)
    }

    override fun renderOverlay(
        renderSource: RenderSource,
        transResult: List<String>,
        translator: Recognizer
    ): Bitmap? {
        val originBitmap = photoAnalyzer.getTextDrawer().draw(
            renderSource,
            translator.getFrameMetadata() ?: return null,
            translator.getHistory() ?: return null,
            transResult
        )

        /*originBitmap ?: return null

        val overlayBitmap = BitmapUtils.reRotateBitmap(
            originBitmap,
            translator.getFrameMetadata()?.rotation ?: 0,
            Facing.BACK
        )
        originBitmap.recycle()*/
        val overlayBitmap = BitmapUtils.rotateBitmap(
            originBitmap ?: return null,
            -(translator.getFrameMetadata()?.rotation ?: return null)
        )
        originBitmap.recycle()
        return overlayBitmap
    }

}