package com.talpa.translate.ocr.result

import android.os.Bundle
import android.view.View
import androidx.fragment.app.Fragment
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.Observer
import androidx.navigation.fragment.findNavController
import com.photo.translation.R
import com.photo.translation.databinding.ContrastSentenceFragmentBinding

/**
 * Create by chenjunsheng on 2020/10/15
 */
class ContrastSentenceFragment : Fragment(R.layout.contrast_sentence_fragment), View.OnClickListener {

    private val model: ContrastViewModel by activityViewModels()
    private lateinit var binding: ContrastSentenceFragmentBinding
    private var mAdapter: ContrastAdapter? = null

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding = ContrastSentenceFragmentBinding.bind(view)

        model.completeModel.observe(viewLifecycleOwner, Observer {
            mAdapter = ContrastAdapter(it)
            binding.contrast.adapter = mAdapter
        })

        binding.toolbar.setNavigationOnClickListener {
            if (!findNavController().navigateUp()) {
                activity?.finish()
            }
        }
        binding.menu.setOnClickListener(this)
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.menu -> {
                findNavController().navigate(R.id.contrastEditFragment)
            }
        }

    }
}