package com.talpa.translate.record

import android.graphics.Bitmap
import android.graphics.Rect
import android.os.Parcel
import android.os.Parcelable


/**
 * Create by chenjunsheng on 2020/8/11
 */

const val START_CAPTURE_PERMISSION_REQUEST = 0
const val CAPTURE_BITMAP_SUCCESS = 1
const val PROCESSOR_BITMAP_FAIL = 2

class CaptureResult(
    private var status: Int = START_CAPTURE_PERMISSION_REQUEST,
    var bitmap: Bitmap? = null,
    var rects: List<Rect>? = null
) : Parcelable {

    companion object {
        @JvmField
        val CREATOR = object : Parcelable.Creator<CaptureResult> {
            override fun createFromParcel(source: Parcel): CaptureResult {
                val status = source.readInt()
                val bitmap = source.readParcelable<Bitmap>(Bitmap::class.java.classLoader)
                val rects: ArrayList<Rect>?
                if (source.readInt() != 0) {
                    val size = source.readInt()
                    rects = ArrayList(size)
                    repeat(size) {
                        rects.add(Rect.CREATOR.createFromParcel(source))
                    }
                } else {
                    rects = null
                }

                return CaptureResult(status, bitmap, rects)
            }

            override fun newArray(size: Int): Array<CaptureResult?> {
                return arrayOfNulls(size)
            }

        }
    }

    fun getStatus() = status

    override fun describeContents(): Int {
        return 0
    }

    override fun writeToParcel(dest: Parcel, flags: Int) {
        dest.writeInt(status)
        dest.writeParcelable(bitmap, flags)
        val localeList = rects
        if (localeList != null) {
            dest.writeInt(1)
            dest.writeInt(localeList.size)
            val iterator = localeList.iterator()
            while (iterator.hasNext()) {
                iterator.next().writeToParcel(dest, flags)
            }
        } else {
            dest.writeInt(0)
        }
    }

    fun readFromParcel(reply: Parcel) {
        status = reply.readInt()
        bitmap = reply.readParcelable(Bitmap::class.java.classLoader)
        val localList = rects
        if (localList != null) {
            reply.readInt()
            reply.readInt()
            val iterator = localList.iterator()
            while (iterator.hasNext()) {
                iterator.next().readFromParcel(reply)
            }
        } else {
            reply.readInt()
        }
    }

}