/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.surface.opengl.draw;

import android.graphics.RectF;
import android.opengl.GLES20;
import com.talpa.translate.camera.surface.opengl.core.Egloo;
import com.talpa.translate.camera.surface.opengl.draw.Gl2dDrawable;
import com.talpa.translate.camera.surface.opengl.extensions.BuffersKt;
import java.nio.FloatBuffer;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u0007\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0010\u0010\u0007\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/talpa/translate/camera/surface/opengl/draw/GlRect;", "Lcom/talpa/translate/camera/surface/opengl/draw/Gl2dDrawable;", "()V", "vertexArray", "Ljava/nio/FloatBuffer;", "getVertexArray", "()Ljava/nio/FloatBuffer;", "setVertexArray", "(Ljava/nio/FloatBuffer;)V", "draw", "", "setRect", "rect", "Landroid/graphics/RectF;", "left", "", "top", "right", "bottom", "array", "", "Companion", "translation_xiaomiRelease"})
public class GlRect
extends Gl2dDrawable {
    @NotNull
    private FloatBuffer vertexArray;
    private static final float[] FULL_RECTANGLE_COORDS;
    public static final Companion Companion;

    @Override
    @NotNull
    public FloatBuffer getVertexArray() {
        return this.vertexArray;
    }

    @Override
    public void setVertexArray(@NotNull FloatBuffer floatBuffer) {
        Intrinsics.checkNotNullParameter((Object)floatBuffer, (String)"<set-?>");
        this.vertexArray = floatBuffer;
    }

    @Deprecated(message="Use setRect", replaceWith=@ReplaceWith(imports={}, expression="setRect(rect)"))
    public void setVertexArray(@NotNull float[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (array.length != 4 * this.getCoordsPerVertex()) {
            throw (Throwable)new IllegalArgumentException("Vertex array should have 8 values.");
        }
        this.getVertexArray().clear();
        this.getVertexArray().put(array);
        this.getVertexArray().flip();
        this.notifyVertexArrayChange();
    }

    @Deprecated(message="Use setRect", replaceWith=@ReplaceWith(imports={}, expression="setRect(rect)"))
    public void setVertexArray(@NotNull RectF rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.setRect(rect);
    }

    public final void setRect(@NotNull RectF rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.setRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public final void setRect(float left, float top, float right, float bottom) {
        this.getVertexArray().clear();
        this.getVertexArray().put(left);
        this.getVertexArray().put(bottom);
        this.getVertexArray().put(right);
        this.getVertexArray().put(bottom);
        this.getVertexArray().put(left);
        this.getVertexArray().put(top);
        this.getVertexArray().put(right);
        this.getVertexArray().put(top);
        this.getVertexArray().flip();
        this.notifyVertexArrayChange();
    }

    @Override
    public void draw() {
        Egloo.checkGlError("glDrawArrays start");
        GLES20.glDrawArrays((int)5, (int)0, (int)this.getVertexCount());
        Egloo.checkGlError("glDrawArrays end");
    }

    public GlRect() {
        float[] fArray = (float[])FULL_RECTANGLE_COORDS.clone();
        this.vertexArray = BuffersKt.floatBufferOf(Arrays.copyOf(fArray, fArray.length));
    }

    static {
        Companion = new Companion(null);
        FULL_RECTANGLE_COORDS = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/talpa/translate/camera/surface/opengl/draw/GlRect$Companion;", "", "()V", "FULL_RECTANGLE_COORDS", "", "translation_xiaomiRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

