package com.talpa.translate.base.utils

import com.google.mlkit.common.MlKitException
import com.talpa.translate.camera.CameraFragment
import java.io.IOException

/**
 * Create by chenjunsheng on 2020/5/8
 */

fun pickerClickedEvent(state: Int) {
    when(state) {
        CameraFragment.STATE_CAMERA -> {
            logEvent(
                PT_lan_click,
                type,
                type_initialize
            )
        }
        CameraFragment.STATE_RESULT_FROM_CAMERA_SUCCESS -> {
            logEvent(
                PT_lan_click,
                type,
                type_camera_end
            )
        }
        CameraFragment.STATE_RESULT_FROM_GALLERY_SUCCESS -> {
            logEvent(
                PT_lan_click,
                type,
                type_gallery_end
            )
        }
        /*CameraFragment.STATE_CROP_FROM_GALLERY -> {
            logEvent(
                PT_lan_click,
                type,
                type_gallery
            )
        }
        CameraFragment.STATE_CROP_FROM_CAMERA -> {
            logEvent(
                PT_lan_click,
                type,
                type_camera
            )
        }*/
    }
}

fun changeLanguageEvent(source: String, target: String) {
    logEvent(
        PT_lan_click_success,
        source_target_language,
        "${source}&${target}"
    )
}

fun translationFailEvent(state: Int, throwable: Throwable?) {
    when(state) {
        CameraFragment.STATE_RESULT_FROM_CAMERA_FAIL -> {
            when (throwable) {
                is MlKitException -> {
                    logEvent(
                        PT__camera_click_fail,
                        errorcode,
                        TIMEOUT
                    )
                }
                is IOException -> {
                    logEvent(
                        PT__camera_click_fail,
                        errorcode,
                        NETWORK_PROBLEM
                    )
                }
                else -> {
                    logEvent(
                        PT__camera_click_fail,
                        errorcode,
                        TRANSLATION_FAIL
                    )
                }
            }
        }
        CameraFragment.STATE_RESULT_FROM_GALLERY_FAIL -> {
            when (throwable) {
                is MlKitException -> {
                    logEvent(
                        PT__gallery_click_fail,
                        errorcode,
                        TIMEOUT
                    )
                }
                is IOException -> {
                    logEvent(
                        PT__gallery_click_fail,
                        errorcode,
                        NETWORK_PROBLEM
                    )
                }
                else -> {
                    logEvent(
                        PT__gallery_click_fail,
                        errorcode,
                        TRANSLATION_FAIL
                    )
                }
            }

        }
    }
}