package com.talpa.translate.activity

import android.app.Activity
import android.os.Bundle
import android.widget.Toast
import androidx.activity.result.contract.ActivityResultContracts
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import com.photo.translation.R
import com.talpa.translate.base.utils.*

/**
 * Create by chenjunsheng on 2021/3/18
 */

const val OCR_RESULT = "ocr_result"

class CameraPickerActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        if (!checkPermission(this)) {
            ActivityCompat.requestPermissions(
                this,
                PERMISSIONS_REQUIRED,
                REQUEST_CODE_PERMISSIONS
            )
            return
        } else {
            setContentView(R.layout.camera_picker_activity)
        }
    }

    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {

        when (requestCode) {
            REQUEST_CODE_PERMISSIONS -> {
                //&& !supportFragmentManager.isStateSaved
                if (checkPermission(applicationContext)) {
                    //TranslationStateEngine.post(TranslationSessionFactory.buildDefaultSession())
                    setContentView(R.layout.activity_camerax)
                } else {
                    finish()
                }
            }
        }

        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
    }
}