package com.talpa.translate.datasource

import android.content.Context
import android.graphics.ImageFormat
import androidx.lifecycle.LifecycleOwner
import com.talpa.translate.camera.view.CameraView
import com.talpa.translate.camera.view.controls.*
import com.talpa.translate.camera.view.gesture.Gesture
import com.talpa.translate.camera.view.gesture.GestureAction
import com.talpa.translate.camera.view.markers.DefaultAutoFocusMarker

/**
 * Create by chenjunsheng on 2021/3/18
 */
class CameraPickerSource : CameraCompatSource() {

    override fun initialize(context: Context, camera: CameraView, lifecycleOwner: LifecycleOwner) {
        mCamera = camera
            .apply {
                engine = Engine.CAMERA2
                setExperimental(true)
                preview = Preview.GL_SURFACE
                playSounds = false
                flash = Flash.OFF
                audio = Audio.OFF
                facing = Facing.BACK
                mapGesture(Gesture.TAP, GestureAction.AUTO_FOCUS)
                mapGesture(Gesture.LONG_TAP, GestureAction.NONE)
                mapGesture(Gesture.PINCH, GestureAction.ZOOM)
                mode = Mode.PICTURE
                setAutoFocusMarker(DefaultAutoFocusMarker())
                useDeviceOrientation = false
                frameProcessingFormat = ImageFormat.YUV_420_888
                grid = Grid.DRAW_3X3
            }
        //parent.addView(mCamera, FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT))
        mCamera.setLifecycleOwner(lifecycleOwner)
        mCamera.addCameraListener(L())
    }
}