/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.base.dialog;

import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentManager;
import com.google.android.material.R;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.photo.translation.R;

public abstract class BaseBottomSheetDialog
extends BottomSheetDialogFragment {
    private static final String TAG = "base_bottom_sheet_dialog";
    private IBehaviorChanged mBehaviorChanged;

    @LayoutRes
    public abstract int getLayoutRes();

    public abstract void bindView(View var1);

    public void onStart() {
        super.onStart();
        this.getDialog().getWindow().setLayout(-1, this.getDialog().getWindow().getAttributes().height);
        this.getDialog().getWindow().setBackgroundDrawableResource(R.color.colorTransparent);
        this.getDialog().getWindow().setDimAmount(0.0f);
        this.getDialog().getWindow().setSoftInputMode(18);
        this.getDialog().setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                if (BaseBottomSheetDialog.this.mBehaviorChanged != null) {
                    BaseBottomSheetDialog.this.mBehaviorChanged.changedState(null, 4);
                }
            }
        });
        this.getDialog().getWindow().addFlags(1024);
        BottomSheetDialog dialog = (BottomSheetDialog)this.getDialog();
        FrameLayout bottomSheet = (FrameLayout)dialog.getDelegate().findViewById(R.id.design_bottom_sheet);
        if (bottomSheet != null) {
            BottomSheetBehavior behavior = BottomSheetBehavior.from((View)bottomSheet);
            behavior.setState(3);
            behavior.setPeekHeight(0);
            if (this.mBehaviorChanged != null) {
                this.mBehaviorChanged.changedState((View)bottomSheet, 3);
            }
            behavior.setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

                public void onStateChanged(@NonNull View bottomSheet, int newState) {
                    if (newState == 5 || newState == 4) {
                        BaseBottomSheetDialog.this.dismiss();
                    }
                    if (BaseBottomSheetDialog.this.mBehaviorChanged != null) {
                        BaseBottomSheetDialog.this.mBehaviorChanged.changedState(bottomSheet, newState);
                    }
                }

                public void onSlide(@NonNull View bottomSheet, float slideOffset) {
                    if (BaseBottomSheetDialog.this.mBehaviorChanged != null) {
                        BaseBottomSheetDialog.this.mBehaviorChanged.changedOffset(bottomSheet, slideOffset);
                    }
                }
            });
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.getDialog().setCanceledOnTouchOutside(this.getCancelOutside());
        View v = inflater.inflate(this.getLayoutRes(), container, false);
        this.bindView(v);
        return v;
    }

    public IBehaviorChanged getBehaviorChanged() {
        return this.mBehaviorChanged;
    }

    public void setBehaviorChanged(IBehaviorChanged behaviorChanged) {
        this.mBehaviorChanged = behaviorChanged;
    }

    public boolean getCancelOutside() {
        return true;
    }

    public String getFragmentTag() {
        return TAG;
    }

    public void show(FragmentManager fragmentManager) {
        this.show(fragmentManager, this.getFragmentTag());
    }

    public static interface IBehaviorChanged {
        public void changedState(View var1, int var2);

        public void changedOffset(View var1, float var2);
    }
}

