/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.engine.meter;

import android.hardware.camera2.params.MeteringRectangle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.engine.CameraEngine;
import com.talpa.translate.camera.view.engine.action.ActionHolder;
import com.talpa.translate.camera.view.engine.action.ActionWrapper;
import com.talpa.translate.camera.view.engine.action.Actions;
import com.talpa.translate.camera.view.engine.action.BaseAction;
import com.talpa.translate.camera.view.engine.meter.BaseMeter;
import com.talpa.translate.camera.view.engine.meter.ExposureMeter;
import com.talpa.translate.camera.view.engine.meter.FocusMeter;
import com.talpa.translate.camera.view.engine.meter.WhiteBalanceMeter;
import com.talpa.translate.camera.view.engine.metering.Camera2MeteringTransform;
import com.talpa.translate.camera.view.engine.offset.Reference;
import com.talpa.translate.camera.view.metering.MeteringRegions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RequiresApi(value=21)
public class MeterAction
extends ActionWrapper {
    private static final String TAG = MeterAction.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private List<BaseMeter> meters;
    private BaseAction action;
    private final MeteringRegions regions;
    private final CameraEngine engine;
    private final boolean skipIfPossible;

    public MeterAction(@NonNull CameraEngine engine, @Nullable MeteringRegions regions, boolean skipIfPossible) {
        this.regions = regions;
        this.engine = engine;
        this.skipIfPossible = skipIfPossible;
    }

    @Override
    @NonNull
    public BaseAction getAction() {
        return this.action;
    }

    public boolean isSuccessful() {
        for (BaseMeter meter : this.meters) {
            if (meter.isSuccessful()) continue;
            LOG.i("isSuccessful:", "returning false.");
            return false;
        }
        LOG.i("isSuccessful:", "returning true.");
        return true;
    }

    @Override
    protected void onStart(@NonNull ActionHolder holder) {
        LOG.w("onStart:", "initializing.");
        this.initialize(holder);
        LOG.w("onStart:", "initialized.");
        super.onStart(holder);
    }

    private void initialize(@NonNull ActionHolder holder) {
        List<MeteringRectangle> areas = new ArrayList<MeteringRectangle>();
        if (this.regions != null) {
            Camera2MeteringTransform transform = new Camera2MeteringTransform(this.engine.getAngles(), this.engine.getPreview().getSurfaceSize(), this.engine.getPreviewStreamSize(Reference.VIEW), this.engine.getPreview().isCropping(), holder.getCharacteristics(this), holder.getBuilder(this));
            MeteringRegions transformed = this.regions.transform(transform);
            areas = transformed.get(Integer.MAX_VALUE, transform);
        }
        ExposureMeter ae = new ExposureMeter(areas, this.skipIfPossible);
        FocusMeter af = new FocusMeter(areas, this.skipIfPossible);
        WhiteBalanceMeter awb = new WhiteBalanceMeter(areas, this.skipIfPossible);
        this.meters = Arrays.asList(ae, af, awb);
        this.action = Actions.together(ae, af, awb);
    }
}

