package com.talpa.translate.camera.view.gesture;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;

import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;

/**
 * Create by chenjunsheng on 2021/1/12
 */
public class ViewPageGestureWrapper implements GestureDetector.OnGestureListener {

    private GestureDetector mGestureDetector;
    private ViewPager mViewPager;

    public ViewPageGestureWrapper(Context context) {
        mGestureDetector = new GestureDetector(context, this);
    }

    public void onInterceptTouchEvent(MotionEvent event) {

    }

    public void setViewPager(ViewPager viewPager) {
        mViewPager = viewPager;
    }

    public void onTouchEvent(MotionEvent event) {
        mGestureDetector.onTouchEvent(event);
        switch (event.getAction()) {
            case MotionEvent.ACTION_UP:
                if (mViewPager != null) {
                    if (mViewPager.isFakeDragging()) {
                        mViewPager.endFakeDrag();
                    }
                }
                break;
            case MotionEvent.ACTION_DOWN:
                if (mViewPager != null) {
                    mViewPager.beginFakeDrag();
                }
                break;
        }
    }

    @Override
    public boolean onDown(MotionEvent e) {
        return false;
    }

    @Override
    public void onShowPress(MotionEvent e) { }

    @Override
    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    @Override
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (mViewPager != null && mViewPager.isFakeDragging()) {
            mViewPager.fakeDragBy(-distanceX);
        }
        return false;
    }

    @Override
    public void onLongPress(MotionEvent e) { }

    @Override
    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }
}
