package com.talpa.translate.base.utils

import android.graphics.Bitmap
import android.graphics.Matrix
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation
import java.security.MessageDigest

/**
 * Create by chenjunsheng on 2020/9/30
 */
class RotateTransformation(rotationAngle: Float = 0f) : BitmapTransformation() {

    private var rotateRotationAngle = rotationAngle

    override fun updateDiskCacheKey(messageDigest: MessageDigest) {

    }

    override fun transform(
        pool: BitmapPool,
        toTransform: Bitmap,
        outWidth: Int,
        outHeight: Int
    ): Bitmap {
        val matrix = Matrix()
        //旋转
        matrix.postRotate(rotateRotationAngle)
        //生成新的Bitmap
        return Bitmap.createBitmap(
            toTransform,
            0,
            0,
            toTransform.width,
            toTransform.height,
            matrix,
            true
        )
    }
}