package com.talpa.translate.base.view

import android.annotation.SuppressLint
import android.content.Context
import android.util.AttributeSet
import android.view.GestureDetector
import android.view.MotionEvent
import androidx.viewpager.widget.ViewPager
import com.ogaclejapan.smarttablayout.SmartTabLayout

/**
 * Create by chenjunsheng on 2021/1/13
 */
class CustomTabLayout @JvmOverloads constructor(
    context: Context,
    attributes: AttributeSet? = null,
    defStyleAttr: Int = 0
) : SmartTabLayout(context, attributes, defStyleAttr), GestureDetector.OnGestureListener {

    private var mViewPager: ViewPager? = null
    private val mGestureDetector: GestureDetector = GestureDetector(context, this)

    override fun setViewPager(viewPager: ViewPager?) {
        super.setViewPager(viewPager)
        mViewPager = viewPager
    }

    @SuppressLint("ClickableViewAccessibility")
    override fun onTouchEvent(ev: MotionEvent): Boolean {
        when (ev.action) {
            MotionEvent.ACTION_DOWN -> {
                mViewPager?.beginFakeDrag()
            }
            MotionEvent.ACTION_UP -> {
                if (mViewPager?.isFakeDragging ?: false) {
                    mViewPager?.endFakeDrag()
                }
            }
        }

        return mGestureDetector.onTouchEvent(ev)
    }

    override fun onDown(e: MotionEvent): Boolean {
        return true
    }

    override fun onShowPress(e: MotionEvent) {}

    override fun onSingleTapUp(e: MotionEvent): Boolean {
        return false
    }

    override fun onScroll(
        e1: MotionEvent,
        e2: MotionEvent,
        distanceX: Float,
        distanceY: Float
    ): Boolean {
        if (mViewPager?.isFakeDragging ?: false) {
            mViewPager?.fakeDragBy(-distanceX * 1.5f)
        }
        return true
    }

    override fun onLongPress(e: MotionEvent) {

    }

    override fun onFling(
        e1: MotionEvent,
        e2: MotionEvent,
        velocityX: Float,
        velocityY: Float
    ): Boolean {
        return false
    }

}