package com.talpa.translate.dialog

import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.DialogFragment
import com.photo.translation.R

/**
 * Create by chenjunsheng on 2020/4/27
 */
class DiskAlertDialog : DialogFragment() {

    interface Callback {
        fun onLackUsageConfirm()
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        dialog?.window?.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        val view = inflater.inflate(R.layout.disk_usage_alert, container)
        view.findViewById<View>(R.id.confirm).setOnClickListener {
            (activity as? Callback)?.onLackUsageConfirm()
        }
        return view
    }
}