/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.engine.action;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.talpa.translate.camera.view.engine.action.Action;
import com.talpa.translate.camera.view.engine.action.ActionCallback;
import com.talpa.translate.camera.view.engine.action.ActionHolder;
import com.talpa.translate.camera.view.engine.action.BaseAction;
import java.util.List;

@RequiresApi(value=21)
class SequenceAction
extends BaseAction {
    private final List<BaseAction> actions;
    private int runningAction = -1;

    SequenceAction(@NonNull List<BaseAction> actions) {
        this.actions = actions;
        this.increaseRunningAction();
    }

    private void increaseRunningAction() {
        boolean last;
        boolean first = this.runningAction == -1;
        boolean bl = last = this.runningAction == this.actions.size() - 1;
        if (last) {
            this.setState(Integer.MAX_VALUE);
        } else {
            ++this.runningAction;
            this.actions.get(this.runningAction).addCallback(new ActionCallback(){

                @Override
                public void onActionStateChanged(@NonNull Action action, int state) {
                    if (state == Integer.MAX_VALUE) {
                        action.removeCallback(this);
                        SequenceAction.this.increaseRunningAction();
                    }
                }
            });
            if (!first) {
                this.actions.get(this.runningAction).onStart(this.getHolder());
            }
        }
    }

    @Override
    protected void onStart(@NonNull ActionHolder holder) {
        super.onStart(holder);
        if (this.runningAction >= 0) {
            this.actions.get(this.runningAction).onStart(holder);
        }
    }

    @Override
    protected void onAbort(@NonNull ActionHolder holder) {
        super.onAbort(holder);
        if (this.runningAction >= 0) {
            this.actions.get(this.runningAction).onAbort(holder);
        }
    }

    @Override
    public void onCaptureStarted(@NonNull ActionHolder holder, @NonNull CaptureRequest request) {
        super.onCaptureStarted(holder, request);
        if (this.runningAction >= 0) {
            this.actions.get(this.runningAction).onCaptureStarted(holder, request);
        }
    }

    @Override
    public void onCaptureProgressed(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull CaptureResult result) {
        super.onCaptureProgressed(holder, request, result);
        if (this.runningAction >= 0) {
            this.actions.get(this.runningAction).onCaptureProgressed(holder, request, result);
        }
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        super.onCaptureCompleted(holder, request, result);
        if (this.runningAction >= 0) {
            this.actions.get(this.runningAction).onCaptureCompleted(holder, request, result);
        }
    }
}

