/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.video.encoding;

import androidx.annotation.NonNull;

public class AudioConfig {
    public int bitRate;
    public int channels = 1;
    public String encoder;
    public String mimeType = "audio/mp4a-latm";
    public int samplingFrequency = 44100;
    final int encoding = 2;
    final int sampleSizePerChannel = 2;
    final int byteRatePerChannel = this.samplingFrequency * 2;

    @NonNull
    AudioConfig copy() {
        AudioConfig config = new AudioConfig();
        config.bitRate = this.bitRate;
        config.channels = this.channels;
        config.encoder = this.encoder;
        config.mimeType = this.mimeType;
        config.samplingFrequency = this.samplingFrequency;
        return config;
    }

    int byteRate() {
        return this.byteRatePerChannel * this.channels;
    }

    int bitRate() {
        return this.byteRate() * 8;
    }

    int audioFormatChannels() {
        if (this.channels == 1) {
            return 16;
        }
        if (this.channels == 2) {
            return 12;
        }
        throw new RuntimeException("Invalid number of channels: " + this.channels);
    }

    int frameSize() {
        return 1024 * this.channels;
    }

    int audioRecordBufferFrames() {
        return 50;
    }

    int bufferPoolMaxSize() {
        return 500;
    }
}

