/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.render;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.talpa.translate.base.common.FrameMetadata;
import com.talpa.translate.base.utils.RotateTransformation;
import com.talpa.translate.ocr.IAnalyzer;
import com.talpa.translate.ocr.Recognizer;
import com.talpa.translate.ocr.datasource.RenderSource;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import com.talpa.translate.render.Render;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/talpa/translate/render/TranslatorRender;", "Lcom/talpa/translate/render/Render;", "context", "Landroid/content/Context;", "photoAnalyzer", "Lcom/talpa/translate/ocr/IAnalyzer;", "(Landroid/content/Context;Lcom/talpa/translate/ocr/IAnalyzer;)V", "getContext", "()Landroid/content/Context;", "analyzeOcrResult", "Lcom/talpa/translate/ocr/datasource/RenderSource;", "bitmap", "Landroid/graphics/Bitmap;", "translator", "Lcom/talpa/translate/ocr/Recognizer;", "renderOverlay", "renderSource", "transResult", "", "", "translation_xiaomiRelease"})
public final class TranslatorRender
implements Render {
    @NotNull
    private final Context context;
    private final IAnalyzer photoAnalyzer;

    @Override
    @NotNull
    public RenderSource analyzeOcrResult(@NotNull Bitmap bitmap2, @NotNull Recognizer translator) {
        Bitmap resizeBitmap;
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        FrameMetadata frameMetadata = translator.getFrameMetadata();
        Intrinsics.checkNotNull((Object)frameMetadata);
        int rotation = frameMetadata.getRotation();
        Bitmap bitmap3 = resizeBitmap = (Bitmap)((RequestBuilder)Glide.with((Context)this.context).asBitmap().load(bitmap2).transform((Transformation)new RotateTransformation(rotation))).submit().get();
        Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"resizeBitmap");
        this.photoAnalyzer.initialize(bitmap3);
        OcrResult ocrResult = translator.getHistory();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (ocrResult == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        OcrResult ocrResult2 = ocrResult;
        bl = false;
        ArrayList<Rect> rects = new ArrayList<Rect>();
        Iterable $this$forEach$iv = ocrResult2.getBlocks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block it = (Block)element$iv;
            boolean bl5 = false;
            rects.add(it.getRect());
        }
        Collection $this$toTypedArray$iv = rects;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Rect[] rectArray = thisCollection$iv.toArray(new Rect[0]);
        if (rectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        int[] colors = this.photoAnalyzer.analyzeTextColor(rectArray);
        Collection $this$toTypedArray$iv2 = rects;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        Rect[] rectArray2 = thisCollection$iv2.toArray(new Rect[0]);
        if (rectArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Bitmap background = this.photoAnalyzer.postAnalyzeArea(rectArray2);
        this.photoAnalyzer.release();
        resizeBitmap.recycle();
        return new RenderSource(background, colors);
    }

    @Override
    @Nullable
    public Bitmap renderOverlay(@NotNull RenderSource renderSource, @NotNull List<String> transResult, @NotNull Recognizer translator) {
        Intrinsics.checkNotNullParameter((Object)renderSource, (String)"renderSource");
        Intrinsics.checkNotNullParameter(transResult, (String)"transResult");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        FrameMetadata frameMetadata = translator.getFrameMetadata();
        if (frameMetadata == null) {
            return null;
        }
        OcrResult ocrResult = translator.getHistory();
        if (ocrResult == null) {
            return null;
        }
        Bitmap originBitmap = this.photoAnalyzer.getTextDrawer().draw(renderSource, frameMetadata, ocrResult, transResult);
        FrameMetadata frameMetadata2 = translator.getFrameMetadata();
        if (frameMetadata2 == null) {
            return null;
        }
        int rotationAngle = -frameMetadata2.getRotation();
        Bitmap bitmap2 = originBitmap;
        if (bitmap2 == null) {
            return null;
        }
        Bitmap overlayBitmap = (Bitmap)((RequestBuilder)Glide.with((Context)this.context).asBitmap().load(bitmap2).transform((Transformation)new RotateTransformation(rotationAngle))).submit().get();
        originBitmap.recycle();
        return overlayBitmap;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public TranslatorRender(@NotNull Context context, @NotNull IAnalyzer photoAnalyzer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)photoAnalyzer, (String)"photoAnalyzer");
        this.context = context;
        this.photoAnalyzer = photoAnalyzer;
    }
}

