package com.talpa.translate.ocr.result

import android.content.res.Configuration
import android.os.Build
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import com.photo.translation.R

/**
 * Create by chenjunsheng on 2020/11/26
 */
class ContrastEditActivity : AppCompatActivity(R.layout.fragment_container_layout_1) {


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        window.setStatusBarColor(ContextCompat.getColor(this, R.color.actionbar_background_color));
        val currentNightMode = resources.configuration.uiMode and Configuration.UI_MODE_NIGHT_MASK
        setDarkStatusIcon(
            when (currentNightMode) {
                Configuration.UI_MODE_NIGHT_NO -> {
                    true
                } // Night mode is not active, we're using the light theme
                else -> {
                    false
                } // Night mode is active, we're using dark theme
            }
        )
        val f = supportFragmentManager.fragmentFactory.instantiate(
            classLoader,
            ContrastEditFragment::class.java.name
        )
        f.arguments = intent.extras
        supportFragmentManager.beginTransaction()
            .replace(R.id.container, f)
            .commitNow()
    }

    protected fun setDarkStatusIcon(dark: Boolean) {
        val decorView = window.decorView
        var vis = decorView.systemUiVisibility
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            if (dark) {
                vis = vis or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
            } else {
                vis = vis and View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR.inv()
            }
        }
        decorView.setSystemUiVisibility(vis)

    }

}