/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.gesture;

import android.content.res.TypedArray;
import androidx.annotation.NonNull;
import com.photo.translation.R;
import com.talpa.translate.camera.view.gesture.GestureAction;

public class GestureParser {
    private int tapAction;
    private int longTapAction;
    private int pinchAction;
    private int horizontalScrollAction;
    private int verticalScrollAction;

    public GestureParser(@NonNull TypedArray array) {
        this.tapAction = array.getInteger(R.styleable.CameraView_cameraGestureTap, GestureAction.DEFAULT_TAP.value());
        this.longTapAction = array.getInteger(R.styleable.CameraView_cameraGestureLongTap, GestureAction.DEFAULT_LONG_TAP.value());
        this.pinchAction = array.getInteger(R.styleable.CameraView_cameraGesturePinch, GestureAction.DEFAULT_PINCH.value());
        this.horizontalScrollAction = array.getInteger(R.styleable.CameraView_cameraGestureScrollHorizontal, GestureAction.DEFAULT_SCROLL_HORIZONTAL.value());
        this.verticalScrollAction = array.getInteger(R.styleable.CameraView_cameraGestureScrollVertical, GestureAction.DEFAULT_SCROLL_VERTICAL.value());
    }

    private GestureAction get(int which) {
        return GestureAction.fromValue(which);
    }

    public GestureAction getTapAction() {
        return this.get(this.tapAction);
    }

    public GestureAction getLongTapAction() {
        return this.get(this.longTapAction);
    }

    public GestureAction getPinchAction() {
        return this.get(this.pinchAction);
    }

    public GestureAction getHorizontalScrollAction() {
        return this.get(this.horizontalScrollAction);
    }

    public GestureAction getVerticalScrollAction() {
        return this.get(this.verticalScrollAction);
    }
}

